package fr.toutatice.cartoun.plugin.cms;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.core.cms.DomainContextualization;


public class CartounDomainContextualization implements DomainContextualization {

    // matches /academie-014
    private static final Pattern DOMAINREGEXP = Pattern.compile("\\/academie-\\d{3}");

    // private static final Pattern DOMAINREGEXP = Pattern.compile("(\\/rennes|\\/nantes|\\/dijon)");


    @Override
    public boolean contextualize(PortalControllerContext portalControllerContext, String domainPath) {
        // si le domain est bien une académie
        final Matcher domainMatcher = DOMAINREGEXP.matcher(domainPath);
        return domainMatcher.matches();
    }

    @Override
    public List<String> getSites(PortalControllerContext portalControllerContext) {
        return Arrays.asList("sap");
    }

    @Override
    public String getDefaultSite(PortalControllerContext portalControllerContext) {
        return "sap";
    }

}
