package fr.toutatice.cartoun.portlet.detailactivite.bean;

import org.nuxeo.ecm.automation.client.model.PropertyMap;


public class ReferentBean {

	String level;
	String levelLabel;
	String identite;
	String subject;
	String email;
	String uid;
	Boolean owner;
	String levelSelected;
	Boolean canDelete;
	Boolean isAuthor;
	String bodyMail;

	public ReferentBean(){
		super();
	}

	public ReferentBean(String level, String identite, String email, String uid,Boolean owner, Boolean canDelete) {
		super();
		this.level = level;
		this.identite = identite;
		this.email = email;
		this.uid = uid;
		this.owner = owner;
	}

    public ReferentBean(PropertyMap ppt, String uidCurrent, String idAuthor) {
		super();
		this.level = ppt.getString("niveau");
        this.uid = ppt.getString("uid");
        this.identite = ppt.getString("displayName");
        this.email = ppt.getString("email");
		this.owner = ppt.getBoolean("owner");
		this.canDelete = (this.uid.equals(uidCurrent) && ((this.owner == null) || !this.owner));
		if(this.uid.equals(idAuthor)){
			this.identite = this.identite.concat(" (Auteur)");
		}
	}

	public String getLevel() {
		return level;
	}
	public void setLevel(String level) {
		this.level = level;
	}
	public String getIdentite() {
		return identite;
	}
	public void setIdentite(String identite) {
		this.identite = identite;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public String getUid() {
		return uid;
	}
	public void setUid(String uid) {
		this.uid = uid;
	}
	public String getLevelLabel() {
		return levelLabel;
	}
	public void setLevelLabel(String levelLabel) {
		this.levelLabel = levelLabel;
	}

	public String getLevelSelected() {
		return levelSelected;
	}

	public void setLevelSelected(String levelSelected) {
		this.levelSelected = levelSelected;
	}

	public Boolean getCanDelete() {
		return canDelete;
	}

	public void setCanDelete(Boolean canDelete) {
		this.canDelete = canDelete;
	}

	public Boolean getOwner() {
		return owner;
	}

	public void setOwner(Boolean owner) {
		this.owner = owner;
	}

	public Boolean getIsAuthor() {
		return isAuthor;
	}

	public void setIsAuthor(Boolean isAuthor) {
		this.isAuthor = isAuthor;
	}

	public String getBodyMail() {
		return bodyMail;
	}

	public void setBodyMail(String bodyMail) {
		this.bodyMail = bodyMail;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}



}
