package fr.toutatice.cartoun.portlet.detailactivite.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Constants;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;

public class BecomeReferentCommand implements INuxeoCommand {

	protected static final Log logger = LogFactory.getLog("fr.toutatice.services.organisation");
	private static final String OP_NUXEO = "UNU.BecomeReferent";

	private final String uid;
	private final String level;
	private final Document docInput;

    public BecomeReferentCommand(String uid, String level, Document docInput) {
		super();
		this.uid = uid;
		this.level = level;
		this.docInput = docInput;
	}

	/**
	 *
	 * @return
	 */
	@Override
    public Object execute(Session nuxeoSession) throws Exception {

		final PropertyMap map = new PropertyMap(1);
		map.set("uid", uid);
		map.set("niveau", level);
        map.set("owner", Boolean.FALSE);
		final OperationRequest reqNuxeo = nuxeoSession.newRequest(OP_NUXEO);
		reqNuxeo.setHeader(Constants.HEADER_NX_SCHEMAS, "*");
		reqNuxeo.set("properties", map);
		reqNuxeo.setInput(docInput);

		final Document doc = (Document) reqNuxeo.execute();
		return doc;

	}

	@Override
    public String getId() {
		return "BecomeReferentCommand";
	}

}
