package fr.toutatice.cartoun.portlet.detailactivite.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Constants;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;

public class DeleteReferentCommand implements INuxeoCommand {

	protected static final Log logger = LogFactory.getLog("fr.toutatice.services.organisation");
	private static final String OP_NUXEO = "UNU.DeleteReferent";

	
	private String uid;	
	private Document docInput;

	public DeleteReferentCommand(String uid,Document docInput) {
		super();		
		this.uid = uid;
		this.docInput = docInput;
	}

	/**
	 * 
	 * @return
	 */
	public Object execute(Session nuxeoSession) throws Exception {

		OperationRequest reqNuxeo = nuxeoSession.newRequest(OP_NUXEO);
		reqNuxeo.setHeader(Constants.HEADER_NX_SCHEMAS, "*");
		reqNuxeo.set("value", uid);
		reqNuxeo.setInput(docInput);

		Document doc = (Document) reqNuxeo.execute();
		
		return doc;

	}

	public String getId() {
		return "BecomeReferentCommand";
	}

}
