/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.portlet.detailactivite.controller;

import com.sun.mail.smtp.SMTPTransport;
import fr.toutatice.cartoun.portlet.detailactivite.bean.ActiviteBean;
import fr.toutatice.cartoun.portlet.detailactivite.bean.LinkBean;
import fr.toutatice.cartoun.portlet.detailactivite.bean.ReferentBean;
import fr.toutatice.cartoun.portlet.detailactivite.command.BecomeReferentCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.CtrlPermissionCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.DeleteReferentCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.PermalinkCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.RetrieveActiviteByIdCommand;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.springframework.expression.ParseException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class DetailActiviteController
extends CMSPortlet
implements PortletContextAware,
PortletConfigAware {
    protected static final Log logger = LogFactory.getLog(DetailActiviteController.class);
    private static final Long ES_REFRESH_TIMEOUT = NumberUtils.toLong((String)System.getProperty("toutatice.cartoun.es.refresh.timeout"), (long)2000L);
    private static final String PIA_CMS_URI = "osivia.cms.uri";
    private static final String ERROR_PAGE = "error";
    private static final String ACTIVITE_PAGE = "detailActivite";
    private PortletContext portletContext;
    private PortletConfig portletConfig;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
    }

    public void destroy() {
        super.destroy();
    }

    @PostConstruct
    public void initNuxeoService() throws Exception {
        super.init();
        if (this.portletContext != null && this.portletContext.getAttribute("nuxeoService") == null) {
            logger.info((Object)" Start  nuxeo service ...");
            this.init(this.portletConfig);
            logger.info((Object)"Nuxeo service  started! ");
        }
    }

    @PreDestroy
    public void cleanUpNuxeoService() throws Exception {
        if (this.portletContext != null && this.portletContext.getAttribute("nuxeoService") == null) {
            logger.info((Object)" Stop  nuxeo service ...");
            this.destroy();
            logger.info((Object)"Nuxeo service  stopped! ");
        }
    }

    @RequestMapping
    public String showActivite(RenderRequest request, RenderResponse response, PortletSession session) throws Exception {
        String returnPage = ERROR_PAGE;
        ActiviteBean act = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String pathAct = window.getProperty(PIA_CMS_URI);
        window.setProperty("osivia.permalinkportlet", "1");
        if (pathAct != null && !"".equals(pathAct)) {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
            CMSPublicationInfos publicationInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), pathAct);
            boolean beingModified = publicationInfos.isBeingModified();
            request.setAttribute("beingModified", (Object)beingModified);
            String level = request.getParameter("levelSelected");
            Date savedDate = new Date(0L);
            Document doc = null;
            if (StringUtils.isBlank((String)level)) {
                NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)pathAct);
                Document liveDoc = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CtrlPermissionCommand("aspire", documentContext.getDoc(), null));
                Boolean canBecomeReferent = liveDoc != null;
                request.setAttribute("canBecomeReferent", (Object)canBecomeReferent);
                Thread.sleep(ES_REFRESH_TIMEOUT);
                doc = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
            } else {
                DirectoryPerson person = (DirectoryPerson)request.getAttribute("osivia.loggedPerson");
                nuxeoController.setDisplayLiveVersion("1");
                NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)pathAct);
                doc = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
                savedDate = doc.getProperties().getDate("dc:modified");
                nuxeoController.executeNuxeoCommand((INuxeoCommand)new BecomeReferentCommand(person.getUid(), level, doc));
                long time = System.currentTimeMillis();
                while (System.currentTimeMillis() < time + ES_REFRESH_TIMEOUT) {
                    Thread.sleep(100L);
                    documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)pathAct);
                    doc = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
                    if (!doc.getProperties().getDate("dc:modified").after(savedDate)) continue;
                }
            }
            act = this.commonInitialization(request, response, doc, nuxeoController);
        }
        if (act != null) {
            returnPage = ACTIVITE_PAGE;
        }
        return returnPage;
    }

    @RequestMapping(params={"action=refreshAfterDelete"})
    public String refreshAfterDeleteReferents(RenderRequest request, RenderResponse response, PortletSession session) throws Exception {
        String returnPage = ERROR_PAGE;
        ActiviteBean act = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String pathAct = window.getProperty(PIA_CMS_URI);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        nuxeoController.setDisplayLiveVersion("1");
        NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)pathAct);
        Document doc = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
        Date savedDate = doc.getProperties().getDate("dc:modified");
        doc = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new DeleteReferentCommand(request.getParameter("selectedUid"), doc));
        Document liveDoc = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CtrlPermissionCommand("aspire", doc, null));
        Boolean canBecomeReferent = liveDoc != null;
        request.setAttribute("canBecomeReferent", (Object)canBecomeReferent);
        long time = System.currentTimeMillis();
        while (System.currentTimeMillis() < time + ES_REFRESH_TIMEOUT) {
            Thread.sleep(100L);
            documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)pathAct);
            doc = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
            if (!doc.getProperties().getDate("dc:modified").after(savedDate)) continue;
        }
        if ((act = this.commonInitialization(request, response, doc, nuxeoController)) != null) {
            returnPage = ACTIVITE_PAGE;
        }
        return returnPage;
    }

    @ActionMapping(params={"action=becomeReferent"})
    public void levelSelected(@ModelAttribute ReferentBean refForm, BindingResult result, ActionResponse response, ActionRequest request, PortletSession session) throws ParseException {
        String level = refForm.getLevelSelected();
        response.setRenderParameter("levelSelected", level);
        response.setRenderParameter("action", "default");
    }

    @ActionMapping(params={"action=deleteReferent"})
    public void deleteReferent(@RequestParam String uid, ActionResponse response, ActionRequest request, PortletSession session) throws ParseException {
        response.setRenderParameter("selectedUid", uid);
        response.setRenderParameter("action", "refreshAfterDelete");
    }

    @ResourceMapping
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse, PortletSession session) throws PortletException, IOException {
        super.serveResource(resourceRequest, resourceResponse);
    }

    @ActionMapping(params={"action=toContact"})
    public void sendMail(@ModelAttribute ReferentBean refForm, BindingResult result, ActionResponse response, ActionRequest request, PortletSession session) {
        DirectoryPerson person = (DirectoryPerson)request.getAttribute("osivia.loggedPerson");
        Properties props = System.getProperties();
        Session mailSession = Session.getInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(mailSession);
        try {
            msg.setFrom((Address)new InternetAddress(person.getEmail()));
            msg.setSubject(refForm.getSubject(), "UTF-8");
            String mailDestinataire = refForm.getEmail();
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mailDestinataire, (boolean)false));
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart txtPart = new MimeBodyPart();
            txtPart.setText(refForm.getBodyMail(), "UTF-8");
            mp.addBodyPart((BodyPart)txtPart);
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            SMTPTransport t = (SMTPTransport)mailSession.getTransport();
            t.connect();
            t.sendMessage((Message)msg, msg.getAllRecipients());
            t.close();
        }
        catch (AddressException e) {
            logger.error((Object)"erreur envoi mail", (Throwable)e);
        }
        catch (MessagingException e) {
            logger.error((Object)"erreur envoi mail", (Throwable)e);
        }
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    private ActiviteBean commonInitialization(RenderRequest request, RenderResponse response, Document doc, NuxeoController nuxeoCtl) throws Exception, CMSException, UnsupportedEncodingException {
        String stats;
        Principal principal = request.getUserPrincipal();
        ActiviteBean act = this.convertNuxeoDocToActiviteBean(doc, nuxeoCtl, principal.getName());
        if (StringUtils.isNotBlank((String)doc.getString("unum:groupeViaeduc"))) {
            String link = (String)nuxeoCtl.executeNuxeoCommand((INuxeoCommand)new PermalinkCommand("viaeduclink", doc));
            act.setViaeduc(link);
        }
        if (StringUtils.equalsIgnoreCase((String)(stats = System.getProperty("stats.enable")), (String)"true")) {
            String idDun = doc.getPath().substring(0, doc.getPath().lastIndexOf(47));
            NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)idDun);
            Document dun = documentContext.getDoc();
            String dunName = dun.getString("dun:subtitle");
            if (dunName == null) {
                dunName = dun.getTitle();
            }
            dunName = dunName.trim();
            act.setDun(dunName);
        }
        request.setAttribute("activity", (Object)act);
        VocabularyEntry vocNivRef = VocabularyHelper.getVocabularyEntry((NuxeoController)nuxeoCtl, (String)"unu_niveauReferent");
        Collection childrenValue = vocNivRef.getChildren().values();
        request.setAttribute("voc", childrenValue);
        request.setAttribute("refForm", (Object)new ReferentBean());
        nuxeoCtl.setCurrentDoc(doc);
        nuxeoCtl.insertContentMenuBarItems();
        return act;
    }

    private ActiviteBean convertNuxeoDocToActiviteBean(Document doc, NuxeoController nxController, String uidCurrent) throws Exception {
        ActiviteBean res = new ActiviteBean();
        res.setId(doc.getId());
        String label = VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_niveau", (String)doc.getString("unum:niv"));
        res.setLevel(label);
        label = VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_duree", (String)doc.getString("unum:duree"));
        res.setDuration(label);
        label = VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_transferabilite", (String)doc.getString("acrp:transferabilite"));
        res.setTransferability(label);
        res.setSummary(doc.getProperties().getString("unum:resume"));
        res.setScenario(doc.getProperties().getString("unum:scenario"));
        res.setTrap(doc.getProperties().getString("unum:piege"));
        res.setAnalysis(doc.getProperties().getString("unum:analyse"));
        res.setTitle(doc.getTitle());
        res.setLastContributor(doc.getProperties().getString("dc:lastContributor"));
        String uidAuthor = doc.getProperties().getString("dc:creator");
        if (uidAuthor != null) {
            DirectoryPerson person = this.getDirectoryService().getPerson(uidAuthor);
            res.setAuthor(StringUtils.defaultString((String)person.getDisplayName()));
        }
        res.setExperitheque(doc.getProperties().getBoolean("unum:experitheque"));
        res.setUrlExpe(doc.getProperties().getString("unum:urlExpe"));
        PropertyList lst = doc.getProperties().getList("acrp:disciplines");
        String[] vocabulaires = new String[]{"disciplines", "disciplines"};
        res.setLstDisciplines(this.protertyStringToListString(vocabulaires, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:niveauxEducatifs");
        String[] vocabulaires1 = new String[]{"niveauxEducatifs", "niveauxEducatifs", "niveauxEducatifs"};
        res.setLstPublics(this.protertyStringToListString(vocabulaires1, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:naturesPedagogiques");
        res.setLstPedagogicals(this.protertyStringToListString(new String[]{"unu_naturepeda"}, lst, nxController));
        ArrayList<String> lstString = new ArrayList<String>();
        for (Object ppt : lst.list()) {
            if (ppt.equals("autres")) {
                StringBuilder sb = new StringBuilder();
                sb.append("Autres");
                if (doc.getProperties().getString("unum:natPedaAutre") != null) {
                    sb.append(" : ");
                    sb.append(doc.getProperties().getString("unum:natPedaAutre"));
                }
                lstString.add(sb.toString());
                continue;
            }
            String labelbis = VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_naturepeda", (String)((String)ppt));
            lstString.add(labelbis);
        }
        lst = (PropertyList)doc.getProperties().get("unum:parcours");
        res.setLstParcours(this.protertyStringToListString(new String[]{"carto_parcours", "carto_parcours"}, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("unum:axe");
        res.setLstAxes(this.protertyStringToListString(new String[]{"carto_axes"}, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:pratique");
        res.setLstPractices(this.protertyStringToListString(new String[]{"unu_pratiques"}, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:cadresUtilisations");
        res.setLstCadres(this.protertyStringToListString(new String[]{"unu_modalite"}, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:lieu");
        res.setLstPlaces(this.protertyStringToListString(new String[]{"unu_lieu"}, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:outils");
        res.setLstTools(this.protertyStringToListString(new String[]{"unu_outils", "unu_outils"}, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:competences");
        res.setLstCompetence(this.protertyStringToListString(null, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("unum:logicielLocal");
        res.setLstSoftware(this.protertyStringToListString(null, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("unum:logicielInternet");
        ArrayList<LinkBean> lstESoftware = new ArrayList<LinkBean>();
        for (int i = 0; i < lst.size(); ++i) {
            lstESoftware.add(new LinkBean(lst.getMap(i).getString("name"), lst.getMap(i).getString("url")));
        }
        res.setLstESoftware(lstESoftware);
        lst = (PropertyList)doc.getProperties().get("unum:referents");
        ArrayList<ReferentBean> lstRefLevel1 = null;
        ArrayList<ReferentBean> lstRefLevel2 = null;
        for (Object referentsO : lst.list()) {
            PropertyMap referentMap = (PropertyMap)referentsO;
            if (referentMap.get("owner") != null && referentMap.getBoolean("owner").booleanValue()) {
                res.setOwner(referentMap.getString("uid"));
            }
            Integer iLevel = new Integer(referentMap.getString("niveau"));
            switch (iLevel) {
                case 1: {
                    if (lstRefLevel1 == null) {
                        lstRefLevel1 = new ArrayList<ReferentBean>();
                        res.setLabelReferent1(VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_niveauReferent", (String)"1"));
                    }
                    lstRefLevel1.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                    break;
                }
                case 2: {
                    if (lstRefLevel2 == null) {
                        lstRefLevel2 = new ArrayList<ReferentBean>();
                        res.setLabelReferent2(VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_niveauReferent", (String)"2"));
                    }
                    lstRefLevel2.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                    break;
                }
                case 3: {
                    if (lstRefLevel2 == null) {
                        lstRefLevel2 = new ArrayList();
                        res.setLabelReferent3(VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_niveauReferent", (String)"3"));
                    }
                    lstRefLevel2.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                }
            }
        }
        res.setLstReferent1(lstRefLevel1);
        res.setLstReferent2(lstRefLevel2);
        PropertyMap map = doc.getProperties().getMap("ttc:vignette");
        if (map != null) {
            String urlVignette = nxController.createFileLink(doc, "ttc:vignette");
            res.setUrlVignette("<img class=\"kartoun-titre-img-float\" src=\"" + urlVignette + "\" />");
        } else {
            res.setUrlVignette("<img class=\"kartoun-titre-img-float\" src=\"/cartoun-detailactivite/img/kartoun-vignette.png\"/>");
        }
        if (doc.getDate("dc:issued") != null) {
            res.setDatePublication(doc.getDate("dc:issued"));
        } else {
            res.setDatePublication(doc.getDate("dc:modified"));
        }
        if (doc.getPath().endsWith(".proxy")) {
            res.setDraft(Boolean.valueOf(false));
        } else {
            res.setDraft(Boolean.valueOf(true));
        }
        PropertyList files = doc.getProperties().getList("files:files");
        if (null != files && !files.isEmpty()) {
            HashMap<String, String> mapPj = new HashMap<String, String>(files.size());
            for (int idx = 0; idx < files.size(); ++idx) {
                mapPj.put(files.getMap(idx).getString("filename"), nxController.createAttachedFileLink(doc.getPath(), String.valueOf(idx)));
            }
            res.setPj(mapPj);
        }
        return res;
    }

    private List<String> protertyStringToListString(String[] vocabularyName, PropertyList lst, NuxeoController nxController) throws Exception {
        ArrayList<String> lstString = new ArrayList<String>();
        for (int i = 0; i < lst.size(); ++i) {
            String value = lst.getString(i);
            if (vocabularyName != null) {
                String[] split = value.split("/");
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < split.length; ++j) {
                    sb.append(VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)vocabularyName[j], (String)split[j].trim()));
                    if (j >= split.length - 1) continue;
                    sb.append(" / ");
                }
                lstString.add(sb.toString());
                continue;
            }
            lstString.add(value);
        }
        return lstString;
    }
}

