package fr.toutatice.cartoun.plugin.detailactivite;

import java.util.HashMap;
import java.util.Map;

import javax.portlet.PortletContext;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.Constants;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.player.Player;
import org.osivia.portal.core.constants.InternalConstants;

import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import fr.toutatice.portail.cms.nuxeo.api.plugin.PluginModule;


public class DetailActivitePlayer extends PluginModule implements INuxeoPlayerModule {

    public static final String DOCTYPE_UsageNUm = "UsageNum";

    public DetailActivitePlayer(PortletContext portletContext) {
        super(portletContext);
    }

    @Override
    public Player getCMSPlayer(DocumentContext<Document> docCtx) {
        final Document doc = docCtx.getDoc();
        final String docType = doc.getType();

        if (StringUtils.equals(docType, DOCTYPE_UsageNUm)) {
            return getDetailActivitePlayer(docCtx);
        }
        return null;
    }

    private Player getDetailActivitePlayer(DocumentContext<Document> docCtx) {
        final Document document = docCtx.getDoc();

        final Map<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put(Constants.WINDOW_PROP_URI, document.getPath());
        windowProperties.put("osivia.doctype", document.getType());
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        // windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.printPortlet", "1");
        windowProperties.put(InternalConstants.PROP_WINDOW_TITLE, document.getTitle());


        final Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("cartoun-detailactivite-portletInstance");

        return linkProps;
    }

}
