<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://www.osivia.org/jsp/taglib/osivia-portal" prefix="op" %>

<%@ page contentType="text/html" isELIgnored="false"%>


<portlet:defineObjects />

<portlet:actionURL name="generate" var="generateUrl" />

<portlet:actionURL name="purge" var="purgeUrl" />


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="glyphicons glyphicons-building"></i>
            <span><op:translate key="INSTITUTIONS" /></span>
        </h3>
    </div>

    <div class="panel-body">
        <dl class="dl-horizontal">
            <dt><op:translate key="ACADEMIES" /></dt>
            <dd>
                <ul class="list-unstyled">
                    <c:forEach items="${configuration.academies}" var="academy">
                        <li>
                            <code>${academy.code}</code>
                            <span>${academy.label}</span>
                            <small class="text-muted">(${academy.name})</small>
                        </li>
                    </c:forEach>
                </ul>
            </dd>
            
            <dt><op:translate key="POOLS_COUNT" /></dt>
            <dd><p>${configuration.poolsCount}</p></dd>
            
            <dt><op:translate key="INSTITUTIONS_COUNT" /></dt>
            <dd><p>${configuration.institutionsCount}</p></dd>
        </dl>
    </div>
</div>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="glyphicons glyphicons-nameplate"></i>
            <span><op:translate key="LDAP" /></span>
        </h3>
    </div>

    <div class="panel-body">
        <dl class="dl-horizontal">
            <dt><op:translate key="PROFILES_BASE_DN" /></dt>
            <dd><p>${configuration.profilesBaseDn}</p></dd>
            
            <dt><op:translate key="PROFILES_DISCIPLINES" /></dt>
            <dd>
                <ul class="list-unstyled">
                    <c:forEach items="${configuration.disciplines}" var="discipline">
                        <li>${discipline}</li>
                    </c:forEach>
                </ul>
            </dd>
            
            <dt><op:translate key="PROFILES_VALUES" /></dt>
            <dd>
                <ul class="list-unstyled">
                    <c:forEach items="${configuration.profiles}" var="profile">
                        <li>${profile}</li>
                    </c:forEach>
                </ul>
            </dd>
        
            <dt><op:translate key="USERS_BASE_DN" /></dt>
            <dd><p>${configuration.usersBaseDn}</p></dd>
            
            <dt><op:translate key="USERS_COUNT" /></dt>
            <dd><p>${configuration.usersCount}</p></dd>
        </dl>
    </div>
</div>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="glyphicons glyphicons-briefcase"></i>
            <span><op:translate key="DOCUMENTS" /></span>
        </h3>
    </div>
    
    <div class="panel-body">
        <dl class="dl-horizontal">
            <dt><op:translate key="FOLDERS_COUNT" /></dt>
            <dd><p>${configuration.foldersCount}</p></dd>
            
            <dt><op:translate key="ACTIVITIES_COUNT" /></dt>
            <dd><p>${configuration.activitiesCount}</p></dd>
            
            <dt><op:translate key="REFERRERS_COUNT" /></dt>
            <dd><p>${configuration.referrersCount}</p></dd>
        </dl>
    </div>
</div>


<p>
    <a href="${generateUrl}" class="btn btn-primary no-ajax-link">
        <i class="glyphicons glyphicons-electricity"></i>
        <span><op:translate key="GENERATE" /></span>
    </a>
    
    <a href="${purgeUrl}" class="btn btn-danger no-ajax-link">
        <i class="glyphicons glyphicons-spray"></i>
        <span><op:translate key="PURGE" /></span>
    </a>
</p>
