/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.generator.repository;

import fr.toutatice.cartoun.generator.model.Academy;
import fr.toutatice.cartoun.generator.model.Configuration;
import fr.toutatice.cartoun.generator.repository.GenerateCommand;
import fr.toutatice.cartoun.generator.repository.GeneratorRepository;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.springframework.stereotype.Repository;

@Repository
public class GeneratorRepositoryImpl
implements GeneratorRepository {
    private static final String PROPERTIES_FILE_NAME = "generator.properties";
    private static final String ACADEMIES_PROPERTY = "generator.academies";
    private static final String POOLS_COUNT_PROPERTY = "generator.pools.count";
    private static final String INSTITUTIONS_COUNT_PROPERTY = "generator.institutions.count";
    private static final String PROFILES_BASE_DN_PROPERTY = "generator.profiles.baseDn";
    private static final String PROFILES_DISCIPLINES = "generator.profiles.disciplines";
    private static final String PROFILES_VALUES = "generator.profiles.values";
    private static final String USERS_BASE_DN_PROPERTY = "generator.users.baseDn";
    private static final String USERS_COUNT_PROPERTY = "generator.users.count";
    private static final String FOLDERS_COUNT_PROPERTY = "generator.folders.count";
    private static final String ACTIVITIES_COUNT_PROPERTY = "generator.activities.count";
    private static final String REFERRERS_COUNT_PROPERTY = "generator.referrers.count";
    private final Properties properties = new Properties();
    private final InitialLdapContext ldapContext;

    public GeneratorRepositoryImpl() throws IOException, NamingException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);
        if (inputStream == null) {
            throw new FileNotFoundException(PROPERTIES_FILE_NAME);
        }
        this.properties.load(inputStream);
        this.properties.put("java.naming.provider.url", "ldap://" + System.getProperty("ldap.host") + ":" + System.getProperty("ldap.port"));
        this.properties.put("java.naming.security.principal", System.getProperty("ldap.manager.dn"));
        this.properties.put("java.naming.security.credentials", System.getProperty("ldap.manager.pswd"));
        this.ldapContext = new InitialLdapContext(this.properties, null);
    }

    public Configuration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String[] academyLabels = StringUtils.split((String)this.properties.getProperty(ACADEMIES_PROPERTY), (String)"|");
        ArrayList<Academy> academies = new ArrayList<Academy>(academyLabels.length);
        for (int i = 0; i < academyLabels.length; ++i) {
            Academy academy = new Academy(i + 1, academyLabels[i]);
            academies.add(academy);
        }
        int poolsCount = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(POOLS_COUNT_PROPERTY), (String)this.properties.getProperty(POOLS_COUNT_PROPERTY)));
        int institutionsCount = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(INSTITUTIONS_COUNT_PROPERTY), (String)this.properties.getProperty(INSTITUTIONS_COUNT_PROPERTY)));
        String profilesBaseDn = StringUtils.defaultIfEmpty((String)window.getProperty(PROFILES_BASE_DN_PROPERTY), (String)this.properties.getProperty(PROFILES_BASE_DN_PROPERTY));
        List<String> disciplines = Arrays.asList(StringUtils.split((String)this.properties.getProperty(PROFILES_DISCIPLINES), (String)"|"));
        List<String> profiles = Arrays.asList(StringUtils.split((String)this.properties.getProperty(PROFILES_VALUES), (String)"|"));
        String usersBaseDn = StringUtils.defaultIfEmpty((String)window.getProperty(USERS_BASE_DN_PROPERTY), (String)this.properties.getProperty(USERS_BASE_DN_PROPERTY));
        int usersCount = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(USERS_COUNT_PROPERTY), (String)this.properties.getProperty(USERS_COUNT_PROPERTY)));
        int foldersCount = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(FOLDERS_COUNT_PROPERTY), (String)this.properties.getProperty(FOLDERS_COUNT_PROPERTY)));
        int activitiesCount = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(ACTIVITIES_COUNT_PROPERTY), (String)this.properties.getProperty(ACTIVITIES_COUNT_PROPERTY)));
        int referrersCount = NumberUtils.toInt((String)StringUtils.defaultIfEmpty((String)window.getProperty(REFERRERS_COUNT_PROPERTY), (String)this.properties.getProperty(REFERRERS_COUNT_PROPERTY)));
        Configuration configuration = new Configuration();
        configuration.setAcademies(academies);
        configuration.setPoolsCount(Integer.valueOf(poolsCount));
        configuration.setInstitutionsCount(Integer.valueOf(institutionsCount));
        configuration.setProfilesBaseDn(profilesBaseDn);
        configuration.setDisciplines(disciplines);
        configuration.setProfiles(profiles);
        configuration.setUsersBaseDn(usersBaseDn);
        configuration.setUsersCount(Integer.valueOf(usersCount));
        configuration.setFoldersCount(Integer.valueOf(foldersCount));
        configuration.setActivitiesCount(Integer.valueOf(activitiesCount));
        configuration.setReferrersCount(Integer.valueOf(referrersCount));
        return configuration;
    }

    public void setConfiguration(PortalControllerContext portalControllerContext, Configuration configuration) throws PortletException {
        if (configuration.getPoolsCount() == null) {
            configuration.setPoolsCount(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(POOLS_COUNT_PROPERTY))));
        }
        if (configuration.getInstitutionsCount() == null) {
            configuration.setInstitutionsCount(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(INSTITUTIONS_COUNT_PROPERTY))));
        }
        if (StringUtils.isBlank((String)configuration.getProfilesBaseDn())) {
            configuration.setProfilesBaseDn(this.properties.getProperty(PROFILES_BASE_DN_PROPERTY));
        }
        if (StringUtils.isBlank((String)configuration.getUsersBaseDn())) {
            configuration.setUsersBaseDn(this.properties.getProperty(USERS_BASE_DN_PROPERTY));
        }
        if (configuration.getUsersCount() == null) {
            configuration.setUsersCount(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(USERS_COUNT_PROPERTY))));
        }
        if (configuration.getFoldersCount() == null) {
            configuration.setFoldersCount(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(FOLDERS_COUNT_PROPERTY))));
        }
        if (configuration.getActivitiesCount() == null) {
            configuration.setActivitiesCount(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(ACTIVITIES_COUNT_PROPERTY))));
        }
        if (configuration.getReferrersCount() == null) {
            configuration.setReferrersCount(Integer.valueOf(NumberUtils.toInt((String)this.properties.getProperty(REFERRERS_COUNT_PROPERTY))));
        }
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        window.setProperty(POOLS_COUNT_PROPERTY, String.valueOf(configuration.getPoolsCount()));
        window.setProperty(INSTITUTIONS_COUNT_PROPERTY, String.valueOf(configuration.getInstitutionsCount()));
        window.setProperty(PROFILES_BASE_DN_PROPERTY, configuration.getProfilesBaseDn());
        window.setProperty(USERS_BASE_DN_PROPERTY, configuration.getUsersBaseDn());
        window.setProperty(USERS_COUNT_PROPERTY, String.valueOf(configuration.getUsersCount()));
        window.setProperty(FOLDERS_COUNT_PROPERTY, String.valueOf(configuration.getFoldersCount()));
        window.setProperty(ACTIVITIES_COUNT_PROPERTY, String.valueOf(configuration.getActivitiesCount()));
        window.setProperty(REFERRERS_COUNT_PROPERTY, String.valueOf(configuration.getReferrersCount()));
    }

    public void generate(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(true);
        Locale locale = nuxeoController.getRequest().getLocale();
        for (Academy academy : configuration.getAcademies()) {
            GenerateCommand command = new GenerateCommand(this.ldapContext, configuration, academy, locale);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        }
    }

    public void purge(PortalControllerContext portalControllerContext) throws PortletException {
        Configuration configuration = this.getConfiguration(portalControllerContext);
        this.purgeProfiles(configuration);
        this.purgeUsers(configuration);
    }

    private void purgeProfiles(Configuration configuration) throws PortletException {
        try {
            String filter = "cn=*";
            SearchControls controls = new SearchControls();
            controls.setSearchScope(1);
            NamingEnumeration<SearchResult> searchResults = this.ldapContext.search(configuration.getProfilesBaseDn(), filter, controls);
            while (searchResults.hasMore()) {
                SearchResult searchResult = searchResults.next();
                if (!searchResult.getName().matches("cn=[0-9]{2}-.+")) continue;
                this.ldapContext.unbind(searchResult.getNameInNamespace());
            }
        }
        catch (NamingException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void purgeUsers(Configuration configuration) throws PortletException {
        try {
            String filter = "uid=*";
            SearchControls controls = new SearchControls();
            controls.setSearchScope(1);
            NamingEnumeration<SearchResult> searchResults = this.ldapContext.search(configuration.getUsersBaseDn(), filter, controls);
            while (searchResults.hasMore()) {
                SearchResult searchResult = searchResults.next();
                if (!searchResult.getName().matches("uid=.+@[0-9]{2}")) continue;
                this.ldapContext.unbind(searchResult.getNameInNamespace());
            }
        }
        catch (NamingException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private NuxeoController getNuxeoController(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        return new NuxeoController(request, response, portletContext);
    }
}

