/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.racvisiontest;

import fr.edu.toulouse.commons.racvision.report.TestResultStateEnum;
import fr.edu.toulouse.commons.racvision.test.AbstractRacVisionTest;
import fr.edu.toulouse.commons.racvision.test.RacVisionTestResult;
import fr.edu.toulouse.commons.racvision.test.State;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LDAPCartounRacvisionTest
extends AbstractRacVisionTest {
    private static final Log LOGGER = LogFactory.getLog(LDAPCartounRacvisionTest.class);
    private static final String RACVISION_LDAP_HOST = System.getProperty("ldap.host");
    private static final String RACVISION_LDAP_PORT = System.getProperty("ldap.port");
    private static final String RACVISION_LDAP_DNBASE = System.getProperty("ldapAA.base");
    private static final String RACVISION_LDAP_AGENT_IDNAME = "uid";
    private static final String ADMIN_LOGIN = System.getProperty("ldap.manager.dn");
    private static final String ADMIN_PASSWORD = System.getProperty("ldap.manager.pswd");
    private static final String CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private String agentLogin;
    private String agentPassword;

    public LDAPCartounRacvisionTest(String idTest, boolean required, String description, boolean duration) {
        super(idTest, required, description, duration);
    }

    public void setAgent(String dnAgent, String password) {
        this.agentLogin = dnAgent;
        this.agentPassword = password;
    }

    public List<RacVisionTestResult> run() {
        ArrayList<RacVisionTestResult> results = new ArrayList<RacVisionTestResult>();
        RacVisionTestResult result = new RacVisionTestResult(this.getId(), this.isRequired(), this.getDescription());
        result.setState(new State(TestResultStateEnum.CRIT, "Connexion \u00e0 l'annuaire avec le compte administrateur impossible."));
        results.add(result);
        ArrayList<String> listParamAbsent = new ArrayList<String>();
        if (StringUtils.isBlank((String)RACVISION_LDAP_HOST)) {
            listParamAbsent.add(RACVISION_LDAP_HOST);
        }
        if (StringUtils.isBlank((String)RACVISION_LDAP_PORT)) {
            listParamAbsent.add(RACVISION_LDAP_PORT);
        }
        if (StringUtils.isBlank((String)RACVISION_LDAP_DNBASE)) {
            listParamAbsent.add(RACVISION_LDAP_DNBASE);
        }
        if (StringUtils.isBlank((String)RACVISION_LDAP_AGENT_IDNAME)) {
            listParamAbsent.add(RACVISION_LDAP_AGENT_IDNAME);
        }
        if (listParamAbsent != null && !listParamAbsent.isEmpty()) {
            StringBuffer message = new StringBuffer("Au moins un param\u00e8tre attendu par la m\u00e9thode est absent, le test n'a pu \u00eatre r\u00e9alis\u00e9. Param\u00e8tre(s) manquant(s) : ");
            for (String paramAbsent : listParamAbsent) {
                message.append(paramAbsent).append(", ");
            }
            String strMsg = message.substring(0, message.length() - 2);
            result.setState(new State(TestResultStateEnum.CRIT, strMsg + "."));
            return results;
        }
        try {
            DirContext dirContext = this.connectAdmin();
            if (this.agentLogin != null && this.agentLogin.length() > 0 && this.agentPassword != null) {
                result.setState(new State(TestResultStateEnum.WARN, "La fiche de l'agent n'existe pas dans l'annuaire."));
                if (this.isAgentExist(dirContext)) {
                    result.setState(new State(TestResultStateEnum.WARN, "Connexion \u00e0 l'annuaire avec un compte agent impossible."));
                    dirContext.close();
                    dirContext = this.connectAgent();
                    result.setState(new State(TestResultStateEnum.OK));
                }
            } else {
                result.setState(new State(TestResultStateEnum.OK));
            }
            dirContext.close();
        }
        catch (CommunicationException e) {
            StringBuffer msg = new StringBuffer("Impossible de se connecter \u00e0 l'annuaire LDAP");
            result.setState(new State(TestResultStateEnum.CRIT, msg.toString()));
            LOGGER.warn((Object)(" - " + e.getMessage()), (Throwable)e);
        }
        catch (NamingException e) {
            StringBuffer msg = new StringBuffer("Erreur JNDI");
            result.setState(new State(TestResultStateEnum.CRIT, msg.toString()));
            LOGGER.warn((Object)(" - " + e.getMessage()), (Throwable)e);
        }
        catch (NumberFormatException e) {
            String msg = "Le num\u00e9ro de port de connexion au serveur LDAP est invalide.";
            result.setState(new State(TestResultStateEnum.CRIT, msg));
        }
        return results;
    }

    protected DirContext connectAdmin() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CONTEXT_FACTORY);
        env.put("java.naming.provider.url", "ldap://" + RACVISION_LDAP_HOST + ":" + RACVISION_LDAP_PORT);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", ADMIN_LOGIN);
        env.put("java.naming.security.credentials", ADMIN_PASSWORD);
        return new InitialDirContext(env);
    }

    protected boolean isAgentExist(DirContext dirContext) throws NamingException {
        String filter = String.format("(%s=%s)", RACVISION_LDAP_AGENT_IDNAME, this.agentLogin);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> result = dirContext.search(RACVISION_LDAP_DNBASE, filter, searchControls);
        return result.hasMore();
    }

    protected DirContext connectAgent() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CONTEXT_FACTORY);
        env.put("java.naming.provider.url", "ldap://" + RACVISION_LDAP_HOST + ":" + RACVISION_LDAP_PORT);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "uid=" + this.agentLogin + "," + RACVISION_LDAP_DNBASE);
        env.put("java.naming.security.credentials", this.agentPassword);
        return new InitialDirContext(env);
    }
}

