/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.racvisiontest;

import fr.edu.toulouse.commons.racvision.report.TestResultStateEnum;
import fr.edu.toulouse.commons.racvision.test.AbstractRacVisionTest;
import fr.edu.toulouse.commons.racvision.test.RacVisionTestResult;
import fr.edu.toulouse.commons.racvision.test.State;
import fr.toutatice.cartoun.command.TestNuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.cache.services.CacheInfo;

public class NuxeoRacvisionTest
extends AbstractRacVisionTest {
    private static final Log LOGGER = LogFactory.getLog(NuxeoRacvisionTest.class);
    private final PortletContext portletContext;
    private boolean isElasticSearch;

    public NuxeoRacvisionTest(PortletContext portletContext, boolean isElasticSearch, String idTest, boolean required, String description, boolean duration) {
        this.portletContext = portletContext;
        this.setElasticSearch(isElasticSearch);
        this.setValeur(idTest, required, description, duration);
    }

    public List<RacVisionTestResult> run() {
        ArrayList<RacVisionTestResult> resultats = new ArrayList<RacVisionTestResult>();
        RacVisionTestResult resultat = new RacVisionTestResult(this.getId(), this.isRequired(), this.getDescription());
        resultats.add(resultat);
        resultat.setState(new State(TestResultStateEnum.CRIT, "Connexion \u00e0 Nuxeo impossible."));
        ArrayList<String> listParamAbsent = new ArrayList<String>();
        if (this.portletContext == null) {
            listParamAbsent.add("contexte de connexion \u00e0 Nuxeo");
        }
        if (!listParamAbsent.isEmpty()) {
            StringBuffer message = new StringBuffer("Au moins un param\u00e8tre attendu par la m\u00e9thode est absent, le test n'a pu \u00eatre r\u00e9alis\u00e9. Param\u00e8tre(s) manquant(s) : ");
            for (String paramAbsent : listParamAbsent) {
                message.append(paramAbsent).append(", ");
            }
            String strMsg = message.substring(0, message.length() - 2);
            resultat.setState(new State(TestResultStateEnum.CRIT, strMsg + "."));
            return resultats;
        }
        try {
            NuxeoController nuxeoController = new NuxeoController(this.portletContext);
            nuxeoController.startNuxeoService();
            nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_ANONYMOUS);
            nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            Object root = nuxeoController.executeNuxeoCommand((INuxeoCommand)new TestNuxeoCommand(this.isElasticSearch()));
            if (root != null) {
                resultat.setState(new State(TestResultStateEnum.OK));
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            resultat.setState(new State(TestResultStateEnum.CRIT, "Impossible d'ex\u00e9cuter une requ\u00eate Nuxeo."));
        }
        return resultats;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public boolean isElasticSearch() {
        return this.isElasticSearch;
    }

    public void setElasticSearch(boolean isElasticSearch) {
        this.isElasticSearch = isElasticSearch;
    }
}

