package fr.toutatice.cartoun.command;

import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;


public class TestNuxeoCommand implements INuxeoCommand {

    private static final String QUERY = "SELECT ecm:uuid FROM Document WHERE ecm:primaryType = 'Root' AND ecm:uuid IS NOT NULL";

    private boolean isElasticSearch;


    public TestNuxeoCommand(boolean isElasticSearch) {
        this.isElasticSearch = isElasticSearch;
    }

    @Override
    public Object execute(Session nuxeoSession) throws Exception {

        OperationRequest request;
        if (isElasticSearch) {
            request = nuxeoSession.newRequest("Document.QueryES");
        } else {
            request = nuxeoSession.newRequest("Document.Query");
        }
        request.set("query", QUERY);
        return request.execute();
    }

    @Override
    public String getId() {
        return "TestNuxeoCommand";
    }

}
