package fr.toutatice.cartoun.racvisiontest;

import java.util.ArrayList;
import java.util.List;

import javax.portlet.PortletContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.status.IStatusService;

import fr.edu.toulouse.commons.racvision.report.TestResultStateEnum;
import fr.edu.toulouse.commons.racvision.test.AbstractRacVisionTest;
import fr.edu.toulouse.commons.racvision.test.RacVisionTestResult;
import fr.edu.toulouse.commons.racvision.test.State;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;


public class StatusServiceRacvisionTest extends AbstractRacVisionTest {

    private static final Log LOGGER = LogFactory.getLog(NuxeoRacvisionTest.class);

    private final PortletContext portletContext;

    public StatusServiceRacvisionTest(PortletContext portletContext, String idTest, boolean required, String description, boolean duration) {
        this.portletContext = portletContext;
        setValeur(idTest, required, description, duration);
    }

    @Override
    public List<RacVisionTestResult> run() {

        List<RacVisionTestResult> resultats = new ArrayList<RacVisionTestResult>();
        RacVisionTestResult resultat = new RacVisionTestResult(getId(), isRequired(), getDescription());
        resultats.add(resultat);
        resultat.setState(new State(TestResultStateEnum.CRIT, "Connexion à Nuxeo impossible."));
        List<String> listParamAbsent = new ArrayList<String>();
        if (this.portletContext == null) {
            listParamAbsent.add("contexte de connexion à Nuxeo");
        }
        if (!listParamAbsent.isEmpty()) {
            StringBuffer message = new StringBuffer(
                    "Au moins un paramètre attendu par la méthode est absent, le test n'a pu être réalisé. Paramètre(s) manquant(s) : ");
            for (String paramAbsent : listParamAbsent) {
                message.append(paramAbsent).append(", ");
            }
            String strMsg = message.substring(0, message.length() - 2);
            resultat.setState(new State(TestResultStateEnum.CRIT, strMsg + "."));
            return resultats;
        }
        try {
            IStatusService serviceStatut = (IStatusService) getPortletContext().getAttribute("StatusService");
            boolean ready = serviceStatut.isReady(NuxeoConnectionProperties.getPrivateBaseUri().toString());
            if (!ready) {
                resultat.setState(new State(TestResultStateEnum.CRIT, "Status indisponible."));
            } else {
                resultat.setState(new State(TestResultStateEnum.OK));
            }
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            resultat.setState(new State(TestResultStateEnum.CRIT, "Impossible d'appeller le service de status."));
        }

        return resultats;
    }

    /**
     * Getter for portletContext.
     *
     * @return the portletContext
     */
    public PortletContext getPortletContext() {
        return portletContext;
    }
}
