package fr.toutatice.cartoun.servlet.supervision;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;

import javax.portlet.PortletContext;

import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.locator.Locator;

import fr.edu.toulouse.commons.racvision.renderer.RacVisionService;
import fr.edu.toulouse.commons.racvision.renderer.RacVisionServlet;
import fr.edu.toulouse.commons.racvision.test.RacVisionTest;
import fr.toutatice.cartoun.racvisiontest.LDAPCartounRacvisionTest;
import fr.toutatice.cartoun.racvisiontest.NuxeoRacvisionTest;
import fr.toutatice.cartoun.racvisiontest.StatusServiceRacvisionTest;


public class CartounRacvisionServlet extends RacVisionServlet implements RacVisionService {

    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("application");

    private static final Date START_DATE = new Date();

    private static PortletContext portletContext;

    private IDirectoryServiceLocator directoryServiceLocator;


    public CartounRacvisionServlet() {
        this.directoryServiceLocator = Locator.findMBean(IDirectoryServiceLocator.class, IDirectoryServiceLocator.MBEAN_NAME);
    }

    @Override
    protected RacVisionService getService() {
        // Renvoie l'interface de description du service RacVision associé.
        // Dans notre cas la servlet implémente l’interface RacvisionService
        return this;
    }

    @Override
    public String getApplicationDescription() {
        // Renvoi la description de l'application testée.
        return resourceBundle.getString("application.description");
    }

    @Override
    public String getApplicationId() {
        // Renvoi l'identifiant de l'application testée.
        return resourceBundle.getString("application.id");
    }

    @Override
    public String getApplicationName() {
        // Renvoi le nom de l'application testée.
        return resourceBundle.getString("application.name");
    }

    @Override
    public Date getApplicationPeriodStart() {
        // Renvoi null, aucune de période de début de disponibilité définie, ou une date, date de début de disponibilité de l’application.
        return START_DATE;
    }

    @Override
    public Date getApplicationPeriodEnd() {
        // Renvoi null, aucune de période de fin de disponibilité définie, ou une date, date de fin de disponibilité de l’application.
        return null;
    }

    @Override
    public String getApplicationVersion() {
        // Renvoi le numéro de version de l'application testée.
        return resourceBundle.getString("application.version");
    }

    @Override
    public String getCharsetName() {
        return "utf-8";
    }


    @Override
    public String getJaxbHeaderPropertyName() {
        return null;
    }

    @Override
    public List<RacVisionTest> getTests() {
        // Renvoi la liste des tests à réaliser.
        List<RacVisionTest> list = new ArrayList<RacVisionTest>();

        list.add(new NuxeoRacvisionTest(getPortletContext(), false, "nuxeoTest", true, "Test de connexion à Nuxeo et exécution d'une requête", true));
        list.add(new NuxeoRacvisionTest(getPortletContext(), true, "nuxeoTestES", true, "Test de connexion à Nuxeo et exécution d'une requête ES", true));
        // list.add(new LDAPRacvisionTest(getDirectoryServiceLocator(), "ldapTest", true, "Test de l'accès à l'annuaire LDAP depuis le portail", true));
        list.add(new LDAPCartounRacvisionTest("ldapTest", true, "Connexion au serveur LDAP", true));
        list.add(new StatusServiceRacvisionTest(getPortletContext(), "statusService", true, "Status retourné par le portail", false));
        return list;
    }


    /**
     * Getter for portletContext.
     *
     * @return the portletContext
     */
    public static PortletContext getPortletContext() {
        return portletContext;
    }


    /**
     * Setter for portletContext.
     *
     * @param portletContext the portletContext to set
     */
    public static void setPortletContext(PortletContext portletContext) {
        CartounRacvisionServlet.portletContext = portletContext;
    }


    /**
     * Getter for directoryServiceLocator.
     *
     * @return the directoryServiceLocator
     */
    public IDirectoryServiceLocator getDirectoryServiceLocator() {
        return directoryServiceLocator;
    }


    /**
     * Setter for directoryServiceLocator.
     *
     * @param directoryServiceLocator the directoryServiceLocator to set
     */
    public void setDirectoryServiceLocator(IDirectoryServiceLocator directoryServiceLocator) {
        this.directoryServiceLocator = directoryServiceLocator;
    }
}
