/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.racvisiontest;

import fr.edu.toulouse.commons.racvision.report.TestResultStateEnum;
import fr.edu.toulouse.commons.racvision.test.AbstractRacVisionTest;
import fr.edu.toulouse.commons.racvision.test.RacVisionTestResult;
import fr.edu.toulouse.commons.racvision.test.State;
import fr.toutatice.cartoun.racvisiontest.NuxeoRacvisionTest;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;

public class LDAPRacvisionTest
extends AbstractRacVisionTest {
    private static final Log LOGGER = LogFactory.getLog(NuxeoRacvisionTest.class);
    private IDirectoryServiceLocator directoryServiceLocator;

    public LDAPRacvisionTest(IDirectoryServiceLocator directoryServiceLocator, String idTest, boolean required, String description, boolean duration) {
        this.setDirectoryServiceLocator(directoryServiceLocator);
        this.setValeur(idTest, required, description, duration);
    }

    public List<RacVisionTestResult> run() {
        ArrayList<RacVisionTestResult> resultats = new ArrayList<RacVisionTestResult>();
        RacVisionTestResult resultat = new RacVisionTestResult(this.getId(), this.isRequired(), this.getDescription());
        resultats.add(resultat);
        resultat.setState(new State(TestResultStateEnum.CRIT, "Connexion \u00e0 Nuxeo impossible."));
        ArrayList<String> listParamAbsent = new ArrayList<String>();
        if (this.directoryServiceLocator == null) {
            listParamAbsent.add("acc\u00e8s au directory service");
        }
        if (!listParamAbsent.isEmpty()) {
            StringBuffer message = new StringBuffer("Au moins un param\u00e8tre attendu par la m\u00e9thode est absent, le test n'a pu \u00eatre r\u00e9alis\u00e9. Param\u00e8tre(s) manquant(s) : ");
            for (String paramAbsent : listParamAbsent) {
                message.append(paramAbsent).append(", ");
            }
            String strMsg = message.substring(0, message.length() - 2);
            resultat.setState(new State(TestResultStateEnum.CRIT, strMsg + "."));
            return resultats;
        }
        try {
            String randomUid = String.valueOf(RandomUtils.nextLong());
            this.getDirectoryServiceLocator().getDirectoryService().getPerson(randomUid);
            resultat.setState(new State(TestResultStateEnum.OK));
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            resultat.setState(new State(TestResultStateEnum.CRIT, "Impossible d'ex\u00e9cuter une requ\u00eate LDAP."));
        }
        return resultats;
    }

    public IDirectoryServiceLocator getDirectoryServiceLocator() {
        return this.directoryServiceLocator;
    }

    public void setDirectoryServiceLocator(IDirectoryServiceLocator directoryServiceLocator) {
        this.directoryServiceLocator = directoryServiceLocator;
    }
}

