package fr.toutatice.services.calendar.common.model.converter;

import java.beans.PropertyEditorSupport;

import org.osivia.services.calendar.common.model.ICalendarColor;
import org.osivia.services.calendar.common.model.converter.CalendarColorPropertyEditor;
import org.springframework.stereotype.Component;

import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;

/**
 * Calendar color property editor.
 * 
 * @author Cédric Krommenhoek
 * @see PropertyEditorSupport
 */
@Component
public class InteractikCalendarColorPropertyEditor extends CalendarColorPropertyEditor {

    /**
     * Constructor.
     */
    public InteractikCalendarColorPropertyEditor() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        ICalendarColor color = InteractikCalendarColor.fromId(text);

        this.setValue(color);
    }

}
