package fr.toutatice.services.calendar.edition.portlet.configuration;

import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.services.calendar.edition.portlet.configuration.CalendarEditionConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.portlet.context.PortletContextAware;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;

/**
 * Interactik calendar edition portlet configuration.
 * 
 * @author Julien Barberet
 * @see CMSPortlet
 * @see PortletContextAware
 */
@Configuration
@ComponentScan(basePackages = {"org.osivia.services.calendar.common", "org.osivia.services.calendar.edition.portlet", "fr.toutatice.services.calendar.edition.portlet"})
public class InteractikCalendarEditionConfiguration extends CalendarEditionConfiguration {

    /**
     * Constructor.
     */
    public InteractikCalendarEditionConfiguration() {
        super();
    }

    /**
     * Get message source.
     *
     * @return message source
     */
    @Bean(name = "messageSource")
    @Override
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames("interactik", "calendar-edition", "calendar-common");
        return messageSource;
    }
    

    /**
     * Get notifications service.
     * 
     * @return notification service
     */
    @Bean
    public INotificationsService getNotificationService() {
        return Locator.findMBean(INotificationsService.class, INotificationsService.MBEAN_NAME);
    }
}
