package fr.toutatice.services.calendar.event.edition.portlet.controller;

import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.event.edition.portlet.controller.CalendarEventEditionController;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

/**
 * Interactik calendar event edition portlet controller.
 *
 * @author Cédric Krommenhoek
 * @see CalendarEventEditionController
 */
@Controller
@RequestMapping("VIEW")
@Primary
public class InteractikCalendarEventEditionController extends CalendarEventEditionController {

    /**
     * Constructor.
     */
    public InteractikCalendarEventEditionController() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute("options") CalendarEditionOptions options) throws PortletException {
        super.view(request, response, options);

        return "view-interactik";
    }

}
