package fr.toutatice.services.calendar.event.edition.portlet.model;

import java.util.Date;
import java.util.SortedMap;

import org.osivia.services.calendar.common.model.AbstractCalendarEditionForm;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.model.CalendarCommonEventForm;
import org.osivia.services.calendar.common.model.CalendarEventDates;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;

/**
 * Calendar edition form java-bean.
 *
 * @author Julien Barberet
 * @see AbstractCalendarEditionForm
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class InteractikCalendarEventEditionForm extends CalendarCommonEventForm {

	/** Department */
	private String departement;
	/** Ville */
	private String ville;
	/** date de début d'inscription : utilisé pour la saisie */
	private String stringDebutInscription;
	/** date de fin d'inscription : utilisé pour la saisie*/
	private String stringFinInscription;
	/** date de début d'inscription : utilisé pour la visualisation */
	private Date dateDebutInscription;
	/** date de fin d'inscription : utilisé pour la visualisation*/
	private Date dateFinInscription;
	/** Url inscription */
	private String urlInscription;
	/** Imported */
	private boolean imported;
	
	private boolean sameDay;
	
	private Date endDateAllDay;
	
	private DocumentDTO document;
	
    /** Dates. */
    private CalendarEventDates dates;

    /** Calendar color. */
    private CalendarColor calendarColor;
    
    private SortedMap<String, String> mapCooperative;
    /**
     * Constructor.
     */
    public InteractikCalendarEventEditionForm() {
        super();
    }
    @Override
	public InteractikCalendarColor getColor() {
		return (InteractikCalendarColor) color;
	}

	public void setColor(InteractikCalendarColor color) {
		this.color = color;
	}
    
    
	public String getDepartement() {
		return departement;
	}


	public void setDepartement(String department) {
		this.departement = department;
	}


	public String getUrlInscription() {
		return urlInscription;
	}


	public void setUrlInscription(String urlInscription) {
		this.urlInscription = urlInscription;
	}

	public boolean isSameDay() {
		return sameDay;
	}


	public void setSameDay(boolean sameDay) {
		this.sameDay = sameDay;
	}


	public Date getEndDateAllDay() {
		return endDateAllDay;
	}


	public void setEndDateAllDay(Date endDateAllDay) {
		this.endDateAllDay = endDateAllDay;
	}


	public DocumentDTO getDocument() {
		return document;
	}


	public void setDocument(DocumentDTO document) {
		this.document = document;
	}
	public CalendarEventDates getDates() {
		return dates;
	}
	public void setDates(CalendarEventDates dates) {
		this.dates = dates;
	}
	public CalendarColor getCalendarColor() {
		return calendarColor;
	}
	public void setCalendarColor(CalendarColor calendarColor) {
		this.calendarColor = calendarColor;
	}
	public String getVille() {
		return ville;
	}
	public void setVille(String ville) {
		this.ville = ville;
	}
	public String getStringDebutInscription() {
		return stringDebutInscription;
	}
	public void setStringDebutInscription(String dateDebutInscription) {
		this.stringDebutInscription = dateDebutInscription;
	}
	public String getStringFinInscription() {
		return stringFinInscription;
	}
	public void setStringFinInscription(String dateFinInscription) {
		this.stringFinInscription = dateFinInscription;
	}
	public Date getDateDebutInscription() {
		return dateDebutInscription;
	}
	public void setDateDebutInscription(Date dateDebutInscription) {
		this.dateDebutInscription = dateDebutInscription;
	}
	public Date getDateFinInscription() {
		return dateFinInscription;
	}
	public void setDateFinInscription(Date dateFinInscription) {
		this.dateFinInscription = dateFinInscription;
	}
	public boolean isImported() {
		return imported;
	}
	public void setImported(boolean imported) {
		this.imported = imported;
	}
	public SortedMap<String, String> getMapCooperative() {
		return mapCooperative;
	}
	public void setMapCooperative(SortedMap<String, String> mapCooperative) {
		this.mapCooperative = mapCooperative;
	}
}
