package fr.toutatice.services.calendar.view.portlet.model.events;

import java.util.List;

import org.osivia.services.calendar.view.portlet.model.events.EventsData;

/**
 * Listed events data abstract super-class
 * 
 * @author Julien Barberet
 * @param <T> event type
 * @see EventsData
 * @see Event
 */
public abstract class InteractikListedEventsData<T extends InteractikEvent> extends EventsData {

    /** Events. */
    private List<T> events;


    /**
     * Default constructor.
     */
    public InteractikListedEventsData() {
        super();
    }


    /**
     * Getter for events.
     *
     * @return the events
     */
    public List<T> getEvents() {
        return this.events;
    }

    /**
     * Setter for events.
     *
     * @param events the events to set
     */
    public void setEvents(List<T> events) {
        this.events = events;
    }

}
