package fr.toutatice.services.calendar.view.portlet.repository;

import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.AGENDA_INTERACTIK;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.CODE_DEPARTEMENT_ACADEMIE;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_22;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_29;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_35;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_56;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_ACADEMIE;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DEPARTEMENT_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.VILLE_PROPERTY;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

import javax.portlet.PortletException;
import javax.portlet.PortletRequest;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.repository.CalendarRepositoryImpl;
import org.osivia.services.calendar.edition.portlet.model.CalendarSynchronizationSource;
import org.osivia.services.calendar.view.portlet.model.CalendarEditionMode;
import org.osivia.services.calendar.view.portlet.model.CalendarViewForm;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventKey;
import org.osivia.services.calendar.view.portlet.model.events.EventToSync;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepositoryImpl;
import org.osivia.services.calendar.view.portlet.repository.command.EventGetCommand;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikEvent;
import fr.toutatice.services.calendar.view.portlet.repository.command.InteractikEventEditionCommand;
import fr.toutatice.services.calendar.view.portlet.repository.command.InteractikEventListCommand;
import fr.toutatice.services.calendar.view.portlet.repository.command.InteractikSynchronizationCommand;

/**
 * Calendar repository implementation.
 *
 * @author Julien Barberet
 * @see CalendarRepositoryImpl
 * @see CalendarViewRepository
 */
@Repository
@Primary
public class InteractikCalendarViewRepositoryImpl extends CalendarViewRepositoryImpl {

    /**
     * Constructor.
     */
    public InteractikCalendarViewRepositoryImpl() {
        super();

    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Event getEvent(PortalControllerContext portalControllerContext, String docid) throws PortletException {
        // Nuxeo controller
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(),
                portalControllerContext.getPortletCtx());
        // CMS path
        String cmsPath = this.getCMSPath(nuxeoController);
        INuxeoCommand nuxeoCommand = new EventGetCommand(cmsPath, docid);
        Document document = (Document) nuxeoController.executeNuxeoCommand(nuxeoCommand);

        return fillEvent(document, nuxeoController);
    }

    
    /**
     * {@inheritDoc}
     */
    @Override
    public void synchronize(PortalControllerContext portalControllerContext, Map<EventKey, EventToSync> map) throws PortletException {
        // Nuxeo controller
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);

        // CMS path
        String cmsPath = this.getCMSPath(nuxeoController);
        String parentPath = nuxeoController.getContentPath();

        INuxeoCommand nuxeoCommand = new InteractikSynchronizationCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, cmsPath, parentPath, ((Map<EventKey, EventToSync>) map));
        nuxeoController.executeNuxeoCommand(nuxeoCommand);
    }
    
    /**
     * {@inheritDoc}
     */
	@Override
	public void save(PortalControllerContext portalControllerContext, CalendarViewForm form, TimeZone clientTimezone) throws PortletException {
		// Nuxeo controller
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);

        String parentPath = nuxeoController.getContentPath();
        form.setParentPath(parentPath);
        // Nuxeo command
        INuxeoCommand command = this.applicationContext.getBean(InteractikEventEditionCommand.class, form, clientTimezone);
        Document document = (Document) nuxeoController.executeNuxeoCommand(command);
        
        if (CalendarEditionMode.EDITION.equals(form.getMode())) {
            // Refresh document
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(document.getPath());
            documentContext.reload();
            document = documentContext.getDocument();
        }

        form.setDocument(document);
	}
    
    /**
     * {@inheritDoc}
     */
    @Override
    public List<Event> getEvents(PortalControllerContext portalControllerContext, Date start, Date end) throws PortletException {
        // Nuxeo controller
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(),
                portalControllerContext.getPortletCtx());
        PortletRequest request = portalControllerContext.getRequest();
        
        boolean agendaInteractik = false;
    	if (request.getAttribute(AGENDA_INTERACTIK) != null)
    	{
    		agendaInteractik = BooleanUtils.toBoolean((Boolean) request.getAttribute(AGENDA_INTERACTIK));
    		request.removeAttribute(AGENDA_INTERACTIK);
    	}
        if (agendaInteractik)
        {
	        boolean cooperative22 = false;
	        boolean cooperative29 = false;
	        boolean cooperative35 = false;
	        boolean cooperative56 = false;
	        boolean cooperativeAcademie = false;
	        if (request.getAttribute(COOPERATIVE_22) != null)
	        {
	        	cooperative22 = BooleanUtils.toBoolean((Boolean) request.getAttribute(COOPERATIVE_22));
	        	request.removeAttribute(COOPERATIVE_22);
	        }
	    	if (request.getAttribute(COOPERATIVE_29) != null)
	    	{
	    		cooperative29 = BooleanUtils.toBoolean((Boolean) request.getAttribute(COOPERATIVE_29));
	    		request.removeAttribute(COOPERATIVE_29);
	    	}
	    	if (request.getAttribute(COOPERATIVE_35) != null)
	    	{
	    		cooperative35 = BooleanUtils.toBoolean((Boolean) request.getAttribute(COOPERATIVE_35));
	    		request.removeAttribute(COOPERATIVE_35);
	    	}
	    	if (request.getAttribute(COOPERATIVE_56) != null)
	    	{
	    		cooperative56 = BooleanUtils.toBoolean((Boolean) request.getAttribute(COOPERATIVE_56));
	    		request.removeAttribute(COOPERATIVE_56);
	    	}
	    	if (request.getAttribute(COOPERATIVE_ACADEMIE) != null)
	    	{
	    		cooperativeAcademie = BooleanUtils.toBoolean((Boolean) request.getAttribute(COOPERATIVE_ACADEMIE));
	    		request.removeAttribute(COOPERATIVE_ACADEMIE);
	    	}
	    	
	        // CMS path
	        String cmsPath = this.getCMSPath(nuxeoController);
	
	        List<Event> events;
	        if (StringUtils.isEmpty(cmsPath)) {
	            events = null;
	        } else {
	            List<CalendarSynchronizationSource> listSource = getSynchronizationSources(portalControllerContext);
	
	            // Nuxeo command
	            INuxeoCommand nuxeoCommand = new InteractikEventListCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, cmsPath, start, end, listSource,
	            		cooperative22, cooperative29, cooperative35, cooperative56, cooperativeAcademie, agendaInteractik);
	            Documents documents = (Documents) nuxeoController.executeNuxeoCommand(nuxeoCommand);
	
	            // Events
	            events = new ArrayList<Event>(documents.size());
	
	            for (Document document : documents) {
	                if ((document.getDate(START_DATE_PROPERTY) != null) && (document.getDate(END_DATE_PROPERTY) != null)) {
	                    // Event
	                	Event event = fillEvent(document, nuxeoController);
	                	InteractikEvent toutaticeEvent = new InteractikEvent(event);
	                	toutaticeEvent.setVille(document.getString(VILLE_PROPERTY));
	                    events.add(toutaticeEvent);
	                }
	            }
	        }
	
	        return events;
        } else
        {
        	return super.getEvents(portalControllerContext, start, end);
        }
    }

    /**
     * Fill event attributes
     * 
     * @param document
     * @param nuxeoController
     * @return event filled
     */
    private Event fillEvent(Document document, NuxeoController nuxeoController) {
        String id = document.getId();
        String title = document.getTitle();
        Date startDate = document.getDate(START_DATE_PROPERTY);
        Date endDate = document.getDate(END_DATE_PROPERTY);
        String bckgcolor = document.getString(BCKG_COLOR);
        String dept = document.getString(DEPARTEMENT_PROPERTY);
        if (dept != null)
        {
        	if (CODE_DEPARTEMENT_ACADEMIE.equals(dept)) bckgcolor = InteractikCalendarColor.ACADEMIE_BRETAGNE.toString();
        	else if ("22".equals(dept)) bckgcolor = InteractikCalendarColor.COTE_D_ARMOR.toString();
        	else if ("29".equals(dept)) bckgcolor = InteractikCalendarColor.FINISTERE.toString();
        	else if ("35".equals(dept)) bckgcolor = InteractikCalendarColor.ILE_ET_VILAINE.toString();
        	else if ("53".equals(dept)) bckgcolor = InteractikCalendarColor.MORBIHAN.toString();
        }
        boolean allDay = BooleanUtils.isTrue(document.getProperties().getBoolean(ALL_DAY_PROPERTY));
        String viewURL = nuxeoController.getLink(document).getUrl();
        String idEventSrc;
        String idParentSrc;
        idEventSrc = document.getString(ID_SOURCE_PROPERTY);
        idParentSrc = document.getString(ID_PARENT_SOURCE_PROPERTY);
        return new Event(id, title, startDate, endDate, allDay, bckgcolor, viewURL, idEventSrc, idParentSrc);
    }

}
