package fr.toutatice.services.calendar.view.portlet.service.generator;

import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.AGENDA_INTERACTIK;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_22;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_29;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_35;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_56;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_ACADEMIE;

import java.util.List;

import javax.portlet.PortletException;
import javax.portlet.PortletRequest;

import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.view.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;

import fr.toutatice.services.calendar.view.portlet.model.calendar.InteractikCalendarData;


/**
 * Calendar generator implementation super-class.
 *
 * @author Julien Barberet
 * @see ICalendarGenerator
 */
public abstract class InteractikCalendarGeneratorImpl extends CalendarGeneratorImpl implements ICalendarGenerator {
    
    /** Calendar repository. */
    @Autowired
    private CalendarViewRepository calendarRepository;
	
	/**
     * Constructor.
     */
    public InteractikCalendarGeneratorImpl() {
        super();
    }

    
    /**
     * {@inheritDoc}
     */
    @Override
    public CalendarData generateCalendarData(PortalControllerContext portalControllerContext, PeriodTypes periodType) throws PortletException {
        CalendarData calendarData = new InteractikCalendarData();
        // Period type
        calendarData.setPeriodType(periodType);
        // Cooperatives
        // By default, all cooperatives are set to true 
        ((InteractikCalendarData) calendarData).setCooperativeCA(true);
        ((InteractikCalendarData) calendarData).setCooperativeFI(true);
        ((InteractikCalendarData) calendarData).setCooperativeIV(true);
        ((InteractikCalendarData) calendarData).setCooperativeMO(true);
        ((InteractikCalendarData) calendarData).setCooperativeAcademie(true);
        // Generator
        calendarData.setGenerator(this);
        // Dates
        this.fillCalendarDates(portalControllerContext, calendarData, null);
        
        return calendarData;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EventsData generateEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        request.setAttribute(COOPERATIVE_22, ((InteractikCalendarData) calendarData).isCooperativeCA());
        request.setAttribute(COOPERATIVE_29, ((InteractikCalendarData) calendarData).isCooperativeFI());
        request.setAttribute(COOPERATIVE_35, ((InteractikCalendarData) calendarData).isCooperativeIV());
        request.setAttribute(COOPERATIVE_56, ((InteractikCalendarData) calendarData).isCooperativeMO());
        request.setAttribute(COOPERATIVE_ACADEMIE, ((InteractikCalendarData) calendarData).isCooperativeAcademie());
        request.setAttribute(AGENDA_INTERACTIK, true);
    	
        // Events
        List<Event> events = this.calendarRepository.getEvents(portalControllerContext, calendarData.getStartDate(), calendarData.getEndDate());

        // Events data
        EventsData eventsData;
        if (events == null) {
            eventsData = null;
        } else {
            eventsData = this.generateSpecializedEventsData(portalControllerContext, calendarData, events);
        }

        return eventsData;
    }

}
