/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.event.edition.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventEditionForm;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.calendar.common.model.Attachment;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.event.edition.portlet.model.comparator.IndexComparator;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractInteractikCalendarEventCommand
implements INuxeoCommand {
    private static final String DATE_FORMAT_PATTERN = "dd/MM/yyyy";
    @Autowired
    private IndexComparator indexComparator;
    protected final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");

    public AbstractInteractikCalendarEventCommand() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public String getId() {
        return null;
    }

    protected PropertyMap getProperties(InteractikCalendarEventEditionForm form) throws ParseException {
        String colorId = form.getColor() == null ? null : form.getColor().getId();
        CalendarColor color = CalendarColor.fromId((String)colorId);
        if (color.equals((Object)form.getCalendarColor())) {
            colorId = null;
        }
        PropertyMap properties = new PropertyMap();
        properties.set("dc:title", form.getTitle());
        properties.set("vevent:dtstart", form.getStartDate());
        properties.set("vevent:dtend", form.getEndDate());
        properties.set("vevent:allDay", Boolean.valueOf(form.isAllDay()));
        properties.set("vevent:location", form.getLocation());
        properties.set("vevent:color", colorId);
        properties.set("note:note", form.getDescription());
        properties.set("ttctik:departement", form.getDepartement());
        properties.set("ttctik:ville", form.getVille());
        properties.set("ttctik:datedebutinscription", this.parseDate(form.getStringDebutInscription()));
        properties.set("ttctik:datefininscription", this.parseDate(form.getStringFinInscription()));
        properties.set("ttctik:urlInscription", form.getUrlInscription());
        return properties;
    }

    protected void setAttachments(DocumentService documentService, Document document, InteractikCalendarEventEditionForm form) throws Exception {
        List files = form.getAttachments().getFiles();
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            TreeSet<Integer> removedIndexes = new TreeSet<Integer>((Comparator<Integer>)this.indexComparator);
            for (Attachment file : files) {
                if (!file.isDeleted() || file.getIndex() == null) continue;
                removedIndexes.add(file.getIndex());
            }
            for (Integer index : removedIndexes) {
                StringBuilder xpath = new StringBuilder();
                xpath.append("files:files");
                xpath.append("/item[");
                xpath.append(index);
                xpath.append("]");
                documentService.removeBlob((DocRef)document, xpath.toString());
            }
            ArrayList<FileBlob> blobs = new ArrayList<FileBlob>(files.size());
            for (Attachment file : files) {
                File temporaryFile = file.getTemporaryFile();
                if (file.isDeleted() || temporaryFile == null) continue;
                String fileName = file.getTemporaryFileName();
                String mimeType = file.getTemporaryMimeType().getBaseType();
                FileBlob blob = new FileBlob(temporaryFile, fileName, mimeType);
                blobs.add(blob);
            }
            if (!blobs.isEmpty()) {
                documentService.setBlobs((DocRef)document, new Blobs(blobs), "files:files");
                for (Attachment file : files) {
                    if (file.getTemporaryFile() == null) continue;
                    file.getTemporaryFile().delete();
                }
            }
        }
    }

    private Date parseDate(String strDate) throws ParseException {
        StringBuilder source = new StringBuilder();
        source.append(StringUtils.trimToEmpty((String)strDate));
        Date date = null;
        if (source.length() > 0) {
            date = this.dateFormat.parse(source.toString());
        }
        return date;
    }
}

