/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.service.generator;

import fr.toutatice.services.calendar.view.portlet.model.calendar.InteractikCalendarData;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.view.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class InteractikCalendarGeneratorImpl
extends CalendarGeneratorImpl
implements ICalendarGenerator {
    @Autowired
    private CalendarViewRepository calendarRepository;

    public CalendarData generateCalendarData(PortalControllerContext portalControllerContext, PeriodTypes periodType) throws PortletException {
        InteractikCalendarData calendarData = new InteractikCalendarData();
        calendarData.setPeriodType(periodType);
        calendarData.setCooperativeCA(true);
        calendarData.setCooperativeFI(true);
        calendarData.setCooperativeIV(true);
        calendarData.setCooperativeMO(true);
        calendarData.setCooperativeAcademie(true);
        calendarData.setGenerator((ICalendarGenerator)this);
        this.fillCalendarDates(portalControllerContext, (CalendarData)calendarData, null);
        return calendarData;
    }

    public EventsData generateEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        request.setAttribute("cooperativeCA", (Object)((InteractikCalendarData)calendarData).isCooperativeCA());
        request.setAttribute("cooperativeFI", (Object)((InteractikCalendarData)calendarData).isCooperativeFI());
        request.setAttribute("cooperativeIV", (Object)((InteractikCalendarData)calendarData).isCooperativeIV());
        request.setAttribute("cooperativeMO", (Object)((InteractikCalendarData)calendarData).isCooperativeMO());
        request.setAttribute("cooperativeAcademie", (Object)((InteractikCalendarData)calendarData).isCooperativeAcademie());
        request.setAttribute("AgendaInteractik", (Object)true);
        List events = this.calendarRepository.getEvents(portalControllerContext, calendarData.getStartDate(), calendarData.getEndDate());
        EventsData eventsData = events == null ? null : this.generateSpecializedEventsData(portalControllerContext, calendarData, events);
        return eventsData;
    }
}

