<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet" %>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://www.toutatice.fr/jsp/taglib/toutatice" prefix="ttc"%>
<%@ taglib uri="http://www.osivia.org/jsp/taglib/osivia-portal" prefix="op" %>

<%@ page contentType="text/html" isELIgnored="false" %>

<portlet:actionURL name="save" var="saveUrl"/>


<div class="calendar calendar-event-edition">
    <form:form action="${saveUrl}" method="post" enctype="multipart/form-data" modelAttribute="form" cssClass="form-horizontal" role="form">
		<c:choose>
			<c:when test="${form.imported}">
				<!-- Title -->
				<div class="form-group">
				    <label class="col-sm-3 col-lg-2 control-label"><op:translate key="CALENDAR_EVENT_TITLE" /></label>
				    <div class="col-sm-9 col-lg-10 form-control-static">
				        <c:choose>
				            <c:when test="${empty form.title}">
				                <span class="text-muted">-</span>
				            </c:when>
				            <c:otherwise>
				                <ttc:transform document="${form.document}" property="dc:title" />
				            </c:otherwise>
				        </c:choose>
				    </div>
				</div>
		        <!-- Dates -->
		        <%@ include file="../event-view/dates.jspf" %>
		
		        <!-- Location -->
		        <%@ include file="../event-view/location.jspf" %>
		        
		        <!-- Color -->
		        <%@ include file="../event-view/color.jspf" %>
		        
		        <!-- Description -->
		        <%@ include file="../event-view/description.jspf" %>
		        
		        <!-- Interactik -->
		        <%@ include file="../event-view/interactik.jspf" %>
	        </c:when>
	        <c:otherwise>
	        	<!-- Title -->
				<%@ include file="title.jspf" %>
		        <!-- Dates -->
	        	<%@ include file="dates.jspf" %>
		
		        <!-- Location -->
		        <%@ include file="location.jspf" %>
		        
		        <!-- Color -->
		        <!-- pas de champ couleur. C'est le dpartement qui porte la couleur -->
		        
		        <!-- Description -->
		        <%@ include file="description.jspf" %>
		        
		        <!-- Interactik -->
		        <%@ include file="interactik.jspf" %>
	        </c:otherwise>
        </c:choose>

        <!-- Buttons -->
        <%@ include file="buttons.jspf" %>
    </form:form>
</div>
