function printCell()
{
	var divScheduler = $JQry("div#scheduler_here");
	var viewEventUrl = divScheduler.data("url-viewevent");
	
	// Variable ajoutée pour corriger un bug dans le composant dhtmlx scheduler
	// En cliquant rapidement (moins de 500ms entre chaque clic) pour créer plusieurs événements, ceux-ci étaient créées mais non enregistrés en base
	// L'objectif est de ne plus les créer, en les filtrant lors de l'appel à l'écouter onBeforeEventCreated
	var last_attached_event;
	
	//Modifier onTemplatesReady doit se faire avant l'appel à scheduler.init
	scheduler.attachEvent("onTemplatesReady", function(){
	    scheduler.templates.event_text=function(start,end,event){
	        return "<a href='" + viewEventUrl+"&doc_id="+event.doc_id + "' class='event_title' onclick='this.href=addScrollParam(this.href,null);'>" + event.text + "</a>"+((typeof event.ville == "undefined")? "" : "<div class='toto'>"+event.ville+"</div>");
	    };
	    scheduler.templates.event_bar_text=function(start,end,event){
	    	return "<a href='" + viewEventUrl+"&doc_id="+event.doc_id + "' class='event_title' onclick='this.href=addScrollParam(this.href,null);'>" + event.text + "</a>"+((typeof event.ville == "undefined")? "" : "<div class='toto'>"+event.ville+"</div>");
	    };
	    scheduler.templates.event_class = function(start,end,ev){
	    	var evClass;
	    	if (ev.extraClass == undefined)
	    	{
	    		evClass = divScheduler.data("color-main-agenda");
	    	} else {
	    		evClass = ev.extraClass;
	    	}
	    	console.log("ExtraClass, color:"+evClass);
		    return evClass;
		}
	});
		
}

function saveEvent(ev)
{
	var divSched = $JQry("div#scheduler_here");
	var urlDragNDrop = divSched.data("url-dragndrop");
	var timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
	// AJAX parameters
	var container = null;
	var options = {
		method : "post",
		postBody : addScrollParam("timezone="+timezone+"&start=" + ev.start_date.toISOString() + "&end=" + ev.end_date.toISOString() 
		+ "&doc_id=" + ev.doc_id+"&title="+ev.text+"&interactik="+divSched.data("agenda-interactik"),divSched.data("period"))
	};
	var callerId = null;
	directAjaxCall(container, options, urlDragNDrop, null, callerId);
}

function addScrollParam(url,targetPeriod)
{	
	var divScheduler = $JQry("div#scheduler_here");
	var urlReturn;
	
	if (divScheduler.data('period') == "month")
	{
		urlReturn = url +"&scrollViewMonth="+ $JQry("div.dhx_cal_data")[0].scrollTop;
	} else if ((divScheduler.data('period') == "day" || divScheduler.data('period') == "week"))
	{
		urlReturn = url +"&scrollViewDayWeek="+ $JQry("div.dhx_cal_data")[0].scrollTop+"&hourPosition="+(24*$JQry("div.dhx_cal_data")[0].scrollTop/$JQry("div.dhx_cal_data")[0].scrollHeight).toFixed(4);
	} else
	{
		urlReturn = url;
	}
	urlReturn = urlReturn + addCooperativeParameters();
	
	return urlReturn;
}

function addCooperativeParameters()
{
	var cooperativeCA = $JQry("input#cooperativeCA").prop('checked');
	var cooperativeFI = $JQry("input#cooperativeFI").prop('checked');
	var cooperativeIV = $JQry("input#cooperativeIV").prop('checked');
	var cooperativeMO = $JQry("input#cooperativeMO").prop('checked');
	var cooperativeAcademie = $JQry("input#cooperativeAcademie").prop('checked');
	var divScheduler = $JQry("div#scheduler_here");
	var interactik = divScheduler.data('agenda-interactik');
	var parameters = "";
	if (interactik) {
		parameters = "&cooperativeCA="+cooperativeCA+"&cooperativeFI="+cooperativeFI+"&cooperativeIV="+cooperativeIV+"&cooperativeMO="+cooperativeMO+"&cooperativeAcademie="+cooperativeAcademie+"&interactik="+interactik;
	} else
	{
		parameters = "&interactik="+interactik;
	}
	
	return parameters;
}

/** Fonction appelée pour le chargement des événements après un clic pour cocher ou non une coopérative */
function dataLoadEvents()
{
	var divScheduler = $JQry("div#scheduler_here");
	var urLoad = divScheduler.data("url-data-filtered");
	var scrollPosition = $JQry("div.dhx_cal_data")[0].scrollTop;

	console.log("dataLoadEvents, cooperativeCA="+$JQry("input#cooperativeCA").prop('checked'));
	jQuery.ajax({
		url: urLoad,
		data: {
			start: scheduler.getState().min_date,
			end: scheduler.getState().max_date,
			coopCA : $JQry("input#cooperativeCA").prop('checked'),
			coopFI : $JQry("input#cooperativeFI").prop('checked'),
			coopIV : $JQry("input#cooperativeIV").prop('checked'),
			coopMO : $JQry("input#cooperativeMO").prop('checked'),
			coopAcademie : $JQry("input#cooperativeAcademie").prop('checked'),
			isInteractik : divScheduler.data('agenda-interactik')
		},
		cache: false,
		dataType: "json",
		success : function(data, status, xhr) {
			scheduler.clearAll();
			scheduler.parse(data, "json");
			scheduler.updateView();
			$JQry("div.dhx_cal_data")[0].scrollTop = scrollPosition;
		},
		error : function(data, status, xhr) {
			console.log( "Erreur lors de l'appel Ajax, status: "+status+ ", data: "+data);
		}
	});
}