/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.event.edition.portlet.model.validation;

import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventEditionForm;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.osivia.services.calendar.common.model.CalendarCommonEventForm;
import org.osivia.services.calendar.event.edition.portlet.model.validation.CalendarEventEditionFormValidator;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

@Component
@Primary
public class InteractikCalendarEventEditionFormValidator
extends CalendarEventEditionFormValidator {
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");

    public boolean supports(Class<?> clazz) {
        return CalendarCommonEventForm.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        InteractikCalendarEventEditionForm form = (InteractikCalendarEventEditionForm)target;
        super.validate(target, errors);
        if (form.isInteractikAgenda()) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"departement", (String)"NotEmpty");
            if (StringUtils.isNotBlank((String)form.getStringDebutInscription())) {
                try {
                    this.dateFormat.parse(form.getStringDebutInscription());
                }
                catch (ParseException e) {
                    errors.rejectValue("stringDebutInscription", "Invalid");
                }
            }
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"stringFinInscription", (String)"NotEmpty");
            if (StringUtils.isNotBlank((String)form.getStringFinInscription())) {
                try {
                    this.dateFormat.parse(form.getStringFinInscription());
                }
                catch (ParseException e) {
                    errors.rejectValue("stringFinInscription", "Invalid");
                }
            }
        }
    }
}

