/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.event.view.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;
import fr.toutatice.services.calendar.event.view.portlet.model.InteractikCalendarEventViewForm;
import java.util.ArrayList;
import java.util.Map;
import javax.portlet.PortletException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.event.view.portlet.model.CalendarEventViewForm;
import org.osivia.services.calendar.event.view.portlet.service.CalendarEventViewServiceImpl;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class InteractikCalendarEventViewServiceImpl
extends CalendarEventViewServiceImpl {
    public InteractikCalendarEventViewForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        VocabularyEntry entry;
        InteractikCalendarEventViewForm form = (InteractikCalendarEventViewForm)this.applicationContext.getBean(InteractikCalendarEventViewForm.class);
        Document document = this.repository.getCurrentDocument(portalControllerContext);
        form.setDocument(this.dao.toDTO(document));
        form.setTitle(document.getString("dc:title"));
        boolean allDay = this.isAllDay(portalControllerContext, document);
        form.setAllDay(allDay);
        form.setStartDate(document.getDate("vevent:dtstart"));
        form.setEndDate(document.getDate("vevent:dtend"));
        form.setSameDay(this.isSameDay((CalendarEventViewForm)form));
        form.setEndDateAllDay(this.getEndDateAllDay((CalendarEventViewForm)form));
        String location = this.getLocation(portalControllerContext, document);
        form.setLocation(location);
        CalendarColor calendarColor = this.getCalendarColor(portalControllerContext, document);
        InteractikCalendarColor color = this.getColor(portalControllerContext, document, calendarColor);
        form.setColor((Enum)color);
        String description = this.getDescription(portalControllerContext, document);
        form.setDescription(description);
        this.setAttachments(portalControllerContext, document, (CalendarEventViewForm)form);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        ArrayList<String> vocabs = new ArrayList<String>();
        vocabs.add("cooperative");
        VocabularyEntry vocabEntry = VocabularyHelper.getVocabularyEntry((NuxeoController)nuxeoController, vocabs, (Boolean)true);
        Map children = vocabEntry.getChildren();
        if (children != null && (entry = (VocabularyEntry)children.get(document.getString("ttctik:departement"))) != null) {
            form.setDepartement(entry.getLabel());
        }
        form.setDateDebutInscription(document.getDate("ttctik:datedebutinscription"));
        form.setDateFinInscription(document.getDate("ttctik:datefininscription"));
        form.setVille(document.getString("ttctik:ville"));
        form.setUrlInscription(document.getString("ttctik:urlInscription"));
        return form;
    }

    private InteractikCalendarColor getColor(PortalControllerContext portalControllerContext, Document document, CalendarColor calendarColor) throws PortletException {
        String colorId;
        if (document == null) {
            colorId = null;
        } else {
            String dept;
            colorId = document.getString("vevent:color");
            if (colorId == null && (dept = document.getString("ttctik:departement")) != null) {
                if ("aca".equals(dept)) {
                    colorId = InteractikCalendarColor.ACADEMIE_BRETAGNE.toString();
                } else if ("22".equals(dept)) {
                    colorId = InteractikCalendarColor.COTE_D_ARMOR.toString();
                } else if ("29".equals(dept)) {
                    colorId = InteractikCalendarColor.FINISTERE.toString();
                } else if ("35".equals(dept)) {
                    colorId = InteractikCalendarColor.ILE_ET_VILAINE.toString();
                } else if ("53".equals(dept)) {
                    colorId = InteractikCalendarColor.MORBIHAN.toString();
                }
            }
        }
        if (colorId == null && calendarColor != null) {
            colorId = calendarColor.getId();
        }
        return InteractikCalendarColor.fromId((String)colorId);
    }
}

