/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.plugin.menubar;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.portlet.PortletException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.services.calendar.plugin.menubar.CalendarMenubarModule;

public class InteractikCalendarMenubarModule
extends CalendarMenubarModule
implements MenubarModule {
    protected static final String CALENDAR_INTERACTIK_TYPE = "AgendaInteractik";
    protected static final String EVENT_INTERACTIK_TYPE = "VEVENTInteractik";
    protected static final String ADD_CALENDAR_INTERACTIK_MENUBAR_ITEM_ID = "ADD_AgendaInteractik";
    protected static final String ADD_EVENT_INTERACTIK_MENUBAR_ITEM_ID = "ADD_VEVENTInteractik";

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        DocumentType documentType;
        if (documentContext != null && (documentType = documentContext.getDocumentType()) != null) {
            Document document = (Document)documentContext.getDocument();
            MenubarItem addCalendar = null;
            MenubarItem addCalendarInteractik = null;
            MenubarItem addEvent = null;
            MenubarItem addEventInteractik = null;
            MenubarItem editCalendar = null;
            MenubarItem editCalendarInteractik = null;
            MenubarItem editEvent = null;
            MenubarItem editEventInteractik = null;
            for (MenubarItem menubarItem : menubar) {
                if ("ADD_Agenda".equals(menubarItem.getId())) {
                    addCalendar = menubarItem;
                    continue;
                }
                if (ADD_CALENDAR_INTERACTIK_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                    addCalendarInteractik = menubarItem;
                    continue;
                }
                if ("ADD_VEVENT".equals(menubarItem.getId())) {
                    addEvent = menubarItem;
                    continue;
                }
                if (ADD_EVENT_INTERACTIK_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                    addEventInteractik = menubarItem;
                    continue;
                }
                if ("ADD".equals(menubarItem.getId())) {
                    if ("Agenda".equals(documentType.getName())) {
                        addEvent = menubarItem;
                        continue;
                    }
                    if (!CALENDAR_INTERACTIK_TYPE.equals(documentType.getName())) continue;
                    addEventInteractik = menubarItem;
                    continue;
                }
                if (!"EDIT".equals(menubarItem.getId())) continue;
                if ("Agenda".equals(documentType.getName())) {
                    editCalendar = menubarItem;
                    continue;
                }
                if (CALENDAR_INTERACTIK_TYPE.equals(documentType.getName())) {
                    editCalendarInteractik = menubarItem;
                    continue;
                }
                if ("VEVENT".equals(documentType.getName())) {
                    editEvent = menubarItem;
                    continue;
                }
                if (!EVENT_INTERACTIK_TYPE.equals(documentType.getName())) continue;
                editEventInteractik = menubarItem;
            }
            if (addCalendar != null) {
                this.customizeMenubarItem(portalControllerContext, addCalendar, document, "Agenda", true);
            }
            if (addCalendarInteractik != null) {
                this.customizeMenubarItem(portalControllerContext, addCalendarInteractik, document, CALENDAR_INTERACTIK_TYPE, true);
            }
            if (addEvent != null) {
                this.customizeMenubarItem(portalControllerContext, addEvent, document, "VEVENT", true);
            }
            if (addEventInteractik != null) {
                this.customizeMenubarItem(portalControllerContext, addEventInteractik, document, EVENT_INTERACTIK_TYPE, true);
            }
            if (editCalendar != null) {
                this.customizeMenubarItem(portalControllerContext, editCalendar, document, "Agenda", false);
            }
            if (editCalendarInteractik != null) {
                this.customizeMenubarItem(portalControllerContext, editCalendarInteractik, document, CALENDAR_INTERACTIK_TYPE, false);
            }
            if (editEvent != null) {
                this.customizeMenubarItem(portalControllerContext, editEvent, document, "VEVENT", false);
            }
            if (editEventInteractik != null) {
                this.customizeMenubarItem(portalControllerContext, editEventInteractik, document, EVENT_INTERACTIK_TYPE, false);
            }
            if (document.getString("sync:idSource") != null && !document.getString("sync:idSource").isEmpty()) {
                try {
                    this.removeEditAndDelete(menubar, documentType, document, portalControllerContext);
                }
                catch (PortletException e) {
                    throw new PortalException((Exception)((Object)e));
                }
            }
        }
    }

    protected void customizeMenubarItem(PortalControllerContext portalControllerContext, MenubarItem item, Document document, String documentType, boolean creation) throws PortalException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.cms.uri", document.getPath());
        properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
        properties.put("osivia.ajaxLink", "1");
        properties.put("osivia.calendar.creation", String.valueOf(creation));
        String instance = "Agenda".equals(documentType) || CALENDAR_INTERACTIK_TYPE.equals(documentType) ? "osivia-services-calendar-edition-instance" : ("VEVENT".equals(documentType) || EVENT_INTERACTIK_TYPE.equals(documentType) ? "osivia-services-calendar-event-edition-instance" : null);
        String url = instance == null ? null : this.portalUrlFactory.getStartPortletUrl(portalControllerContext, instance, properties);
        item.setUrl(url);
        item.setOnclick(null);
        item.setHtmlClasses(null);
    }

    public void removeEditAndDelete(List<MenubarItem> menubar, DocumentType documentType, Document document, PortalControllerContext portalControllerContext) throws PortletException {
        if (documentType != null && ("VEVENT".equals(documentType.getName()) || EVENT_INTERACTIK_TYPE.equals(documentType.getName()))) {
            HashSet<MenubarItem> removedItems = new HashSet<MenubarItem>();
            boolean isInInteractikAgenda = this.isInteractikAgenda(document, portalControllerContext);
            boolean isImportedInteractikAgenda = this.isImportedInteractikAgenda(document);
            for (MenubarItem menubarItem : menubar) {
                if (!isInInteractikAgenda || !isImportedInteractikAgenda || !"EDIT".equals(menubarItem.getId()) && !"DELETE".equals(menubarItem.getId())) continue;
                removedItems.add(menubarItem);
            }
            menubar.removeAll(removedItems);
        }
    }

    private boolean isInteractikAgenda(Document document, PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String parentPath = NuxeoController.getParentPath((String)document.getPath());
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(parentPath);
        Document documentParent = documentContext.getDocument();
        return CALENDAR_INTERACTIK_TYPE.equals(documentParent.getType());
    }

    private boolean isImportedInteractikAgenda(Document document) throws PortletException {
        String imported = document.getString("ttctik:imported");
        boolean isImported = false;
        if (imported != null) {
            isImported = new Boolean(imported);
        }
        return isImported;
    }
}

