/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;
import fr.toutatice.services.calendar.view.portlet.model.InteractikCalendarViewForm;
import fr.toutatice.services.calendar.view.portlet.model.calendar.InteractikCalendarData;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.batch.IBatchService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.view.portlet.controller.ViewCalendarController;
import org.osivia.services.calendar.view.portlet.model.CalendarEditionMode;
import org.osivia.services.calendar.view.portlet.model.CalendarViewForm;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
@Primary
public class InteractikViewCalendarController
extends ViewCalendarController {
    private static final String SCROLL_DAY_WEEK_PARAMETER = "scrollViewDayWeek";
    private static final String SCROLL_MONTH_PARAMETER = "scrollViewMonth";
    private static final String PRIMARY_CALENDAR_COLOR = "cal:color";
    private static final String DOCUMENT_REQUEST_ATTRIBUTE = "osivia.calendar.document";
    private static final String CMS_PATH_WINDOW_PROPERTY = "osivia.calendar.cmsPath";
    @Autowired
    private IBatchService batchService;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @RequestParam(value="date", required=false) String startDate, @RequestParam(value="period", required=false) String periodType, @RequestParam(value="scrollViewDayWeek", required=false) String scrollViewDayWeek, @RequestParam(value="scrollViewMonth", required=false) String scrollViewMonth, @ModelAttribute CalendarData calendarData) throws PortletException {
        InteractikCalendarData interactikCalendarData = (InteractikCalendarData)calendarData;
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        Document document = this.getDocument(nuxeoController, portalControllerContext);
        interactikCalendarData.setAgendaInteractik("AgendaInteractik".equals(document.getType()));
        if (interactikCalendarData.isAgendaInteractik()) {
            if (StringUtils.isNotEmpty((String)request.getParameter("cooperativeCA"))) {
                interactikCalendarData.setCooperativeCA(BooleanUtils.toBoolean((String)request.getParameter("cooperativeCA")));
            }
            if (StringUtils.isNotEmpty((String)request.getParameter("cooperativeFI"))) {
                interactikCalendarData.setCooperativeFI(BooleanUtils.toBoolean((String)request.getParameter("cooperativeFI")));
            }
            if (StringUtils.isNotEmpty((String)request.getParameter("cooperativeIV"))) {
                interactikCalendarData.setCooperativeIV(BooleanUtils.toBoolean((String)request.getParameter("cooperativeIV")));
            }
            if (StringUtils.isNotEmpty((String)request.getParameter("cooperativeMO"))) {
                interactikCalendarData.setCooperativeMO(BooleanUtils.toBoolean((String)request.getParameter("cooperativeMO")));
            }
            if (StringUtils.isNotEmpty((String)request.getParameter("cooperativeAcademie"))) {
                interactikCalendarData.setCooperativeAcademie(BooleanUtils.toBoolean((String)request.getParameter("cooperativeAcademie")));
            }
        }
        String url = super.view(request, response, startDate, periodType, scrollViewDayWeek, scrollViewMonth, (CalendarData)interactikCalendarData);
        if (interactikCalendarData.isAgendaInteractik()) {
            calendarData.setAgendaBackgroundColor(InteractikCalendarColor.ACADEMIE_BRETAGNE.getBackgroundClass());
        } else {
            String colorIdAgenda = document.getString(PRIMARY_CALENDAR_COLOR);
            calendarData.setAgendaBackgroundColor(CalendarColor.fromId((String)colorIdAgenda).getBackgroundClass());
        }
        return url;
    }

    @ResourceMapping(value="initSchedulerData")
    public void initSchedulerData(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="calendarData") CalendarData calendarData, @RequestParam(value="period", required=false) String periodTypeName, @RequestParam(value="date", required=false) Date selectedDate) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (request.getParameter("interactik") != null) {
            ((InteractikCalendarData)calendarData).setAgendaInteractik(BooleanUtils.toBoolean((String)request.getParameter("interactik")));
        }
        this.dataLoading(response, portalControllerContext, calendarData);
    }

    @ResourceMapping(value="loadData")
    public void loadData(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="calendarData") CalendarData calendarData, @RequestParam(value="start") Date startDate, @RequestParam(value="end") Date endDate) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        calendarData.setStartDate(startDate);
        if (request.getParameter("interactik") != null) {
            ((InteractikCalendarData)calendarData).setAgendaInteractik(BooleanUtils.toBoolean((String)request.getParameter("interactik")));
        }
        if (endDate != null) {
            calendarData.setEndDate(endDate);
        }
        this.dataLoading(response, portalControllerContext, calendarData);
    }

    @ResourceMapping(value="loadDataFiltered")
    public void loadDataFiltered(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="calendarData") CalendarData calendarData, @RequestParam(value="start") Date startDate, @RequestParam(value="end") Date endDate, @RequestParam(value="coopCA") String coopCA, @RequestParam(value="coopFI") String coopFI, @RequestParam(value="coopIV") String coopIV, @RequestParam(value="coopMO") String coopMO, @RequestParam(value="coopAcademie") String coopAcademie) throws PortletException, IOException {
        ((InteractikCalendarData)calendarData).setCooperativeCA(BooleanUtils.toBoolean((String)request.getParameter("coopCA")));
        ((InteractikCalendarData)calendarData).setCooperativeFI(BooleanUtils.toBoolean((String)request.getParameter("coopFI")));
        ((InteractikCalendarData)calendarData).setCooperativeIV(BooleanUtils.toBoolean((String)request.getParameter("coopIV")));
        ((InteractikCalendarData)calendarData).setCooperativeMO(BooleanUtils.toBoolean((String)request.getParameter("coopMO")));
        ((InteractikCalendarData)calendarData).setCooperativeAcademie(BooleanUtils.toBoolean((String)request.getParameter("coopAcademie")));
        ((InteractikCalendarData)calendarData).setAgendaInteractik(BooleanUtils.toBoolean((String)request.getParameter("isInteractik")));
        super.loadData(request, response, calendarData, startDate, endDate);
    }

    @ActionMapping(value="dragndrop")
    public void dragndrop(ActionRequest request, ActionResponse response, PortletSession session, @RequestParam(value="start") String startDate, @RequestParam(value="end") String endDate, @RequestParam(value="doc_id") String docid, @RequestParam(value="title") String title, @RequestParam(value="timezone") String timezoneName, @RequestParam(value="scrollViewDayWeek", required=false) String scrollViewDayWeek, @RequestParam(value="scrollViewMonth", required=false) String scrollViewMonth, @RequestParam(value="period") String period, @RequestParam(value="date") String date) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        InteractikCalendarViewForm form = new InteractikCalendarViewForm();
        form.setAgendaInteractik(BooleanUtils.toBoolean((String)request.getParameter("interactik")));
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            form.setEndDate(df1.parse(endDate));
            form.setStartDate(df1.parse(startDate));
            form.setTitle(title);
            if ("undefined".equals(docid)) {
                form.setDocId(null);
                form.setMode(CalendarEditionMode.CREATION);
            } else {
                form.setDocId(docid);
                form.setMode(CalendarEditionMode.EDITION);
            }
            TimeZone timezone = null;
            timezone = timezoneName.isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(timezoneName);
            this.calendarService.save(portalControllerContext, (CalendarViewForm)form, timezone);
        }
        catch (ParseException e) {
            Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
            this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_EVENT_NOT_SAVE"), NotificationsType.WARNING);
        }
        this.setResponseParameter(response, date, period, scrollViewDayWeek, scrollViewMonth);
    }

    private Document getDocument(NuxeoController nuxeoController, PortalControllerContext portalControllerContext) throws PortletException {
        Document document;
        block4: {
            PortletRequest request = nuxeoController.getRequest();
            document = (Document)request.getAttribute(DOCUMENT_REQUEST_ATTRIBUTE);
            if (document == null) {
                try {
                    String cmsPath = this.getCMSPath(nuxeoController, portalControllerContext);
                    if (StringUtils.isNotEmpty((String)cmsPath)) {
                        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(cmsPath);
                        document = documentContext.getDocument();
                        request.setAttribute(DOCUMENT_REQUEST_ATTRIBUTE, (Object)document);
                    }
                }
                catch (NuxeoException e) {
                    if (1 == e.getErrorCode()) break block4;
                    throw new PortletException((Throwable)e);
                }
            }
        }
        return document;
    }

    private String getCMSPath(NuxeoController nuxeoController, PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String cmsPath = window.getProperty(CMS_PATH_WINDOW_PROPERTY);
        if (!StringUtils.isNotBlank((String)cmsPath)) {
            window = WindowFactory.getWindow((PortletRequest)nuxeoController.getRequest());
            cmsPath = window.getPageProperty("osivia.cms.basePath");
        }
        return nuxeoController.getComputedPath(cmsPath);
    }
}

