/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;
import fr.toutatice.services.calendar.view.portlet.model.InteractikCalendarViewForm;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikEvent;
import fr.toutatice.services.calendar.view.portlet.repository.command.InteractikEventEditionCommand;
import fr.toutatice.services.calendar.view.portlet.repository.command.InteractikEventListCommand;
import fr.toutatice.services.calendar.view.portlet.repository.command.InteractikSynchronizationCommand;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.view.portlet.model.CalendarEditionMode;
import org.osivia.services.calendar.view.portlet.model.CalendarViewForm;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventKey;
import org.osivia.services.calendar.view.portlet.model.events.EventToSync;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepositoryImpl;
import org.osivia.services.calendar.view.portlet.repository.command.EventGetCommand;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

@Repository
@Primary
public class InteractikCalendarViewRepositoryImpl
extends CalendarViewRepositoryImpl {
    public Event getEvent(PortalControllerContext portalControllerContext, String docid) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String cmsPath = this.getCMSPath(nuxeoController);
        EventGetCommand nuxeoCommand = new EventGetCommand(cmsPath, docid);
        Document document = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
        return this.fillEvent(document, nuxeoController);
    }

    public void synchronize(PortalControllerContext portalControllerContext, Map<EventKey, EventToSync> map) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String cmsPath = this.getCMSPath(nuxeoController);
        String parentPath = nuxeoController.getContentPath();
        InteractikSynchronizationCommand nuxeoCommand = new InteractikSynchronizationCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, cmsPath, parentPath, map);
        nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
    }

    public void save(PortalControllerContext portalControllerContext, CalendarViewForm form, TimeZone clientTimezone) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String parentPath = nuxeoController.getContentPath();
        form.setParentPath(parentPath);
        boolean agendaInteractik = false;
        if (form instanceof InteractikCalendarViewForm) {
            agendaInteractik = ((InteractikCalendarViewForm)form).isAgendaInteractik();
        }
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(InteractikEventEditionCommand.class, new Object[]{form, clientTimezone, agendaInteractik});
        Document document = (Document)nuxeoController.executeNuxeoCommand(command);
        if (CalendarEditionMode.EDITION.equals((Object)form.getMode())) {
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(document.getPath());
            documentContext.reload();
            document = documentContext.getDocument();
        }
        form.setDocument((DocRef)document);
    }

    public List<Event> getEvents(PortalControllerContext portalControllerContext, Date start, Date end) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        PortletRequest request = portalControllerContext.getRequest();
        boolean agendaInteractik = false;
        if (request.getAttribute("AgendaInteractik") != null) {
            agendaInteractik = BooleanUtils.toBoolean((Boolean)((Boolean)request.getAttribute("AgendaInteractik")));
            request.removeAttribute("AgendaInteractik");
        }
        if (agendaInteractik) {
            ArrayList<InteractikEvent> events;
            String cmsPath;
            boolean cooperative22 = false;
            boolean cooperative29 = false;
            boolean cooperative35 = false;
            boolean cooperative56 = false;
            boolean cooperativeAcademie = false;
            if (request.getAttribute("cooperativeCA") != null) {
                cooperative22 = BooleanUtils.toBoolean((Boolean)((Boolean)request.getAttribute("cooperativeCA")));
                request.removeAttribute("cooperativeCA");
            }
            if (request.getAttribute("cooperativeFI") != null) {
                cooperative29 = BooleanUtils.toBoolean((Boolean)((Boolean)request.getAttribute("cooperativeFI")));
                request.removeAttribute("cooperativeFI");
            }
            if (request.getAttribute("cooperativeIV") != null) {
                cooperative35 = BooleanUtils.toBoolean((Boolean)((Boolean)request.getAttribute("cooperativeIV")));
                request.removeAttribute("cooperativeIV");
            }
            if (request.getAttribute("cooperativeMO") != null) {
                cooperative56 = BooleanUtils.toBoolean((Boolean)((Boolean)request.getAttribute("cooperativeMO")));
                request.removeAttribute("cooperativeMO");
            }
            if (request.getAttribute("cooperativeAcademie") != null) {
                cooperativeAcademie = BooleanUtils.toBoolean((Boolean)((Boolean)request.getAttribute("cooperativeAcademie")));
                request.removeAttribute("cooperativeAcademie");
            }
            if (StringUtils.isEmpty((String)(cmsPath = this.getCMSPath(nuxeoController)))) {
                events = null;
            } else {
                List listSource = this.getSynchronizationSources(portalControllerContext);
                InteractikEventListCommand nuxeoCommand = new InteractikEventListCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, cmsPath, start, end, listSource, cooperative22, cooperative29, cooperative35, cooperative56, cooperativeAcademie, agendaInteractik);
                Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
                events = new ArrayList<InteractikEvent>(documents.size());
                for (Document document : documents) {
                    if (document.getDate("vevent:dtstart") == null || document.getDate("vevent:dtend") == null) continue;
                    Event event = this.fillEvent(document, nuxeoController);
                    InteractikEvent toutaticeEvent = new InteractikEvent(event);
                    toutaticeEvent.setVille(document.getString("ttctik:ville"));
                    events.add(toutaticeEvent);
                }
            }
            return events;
        }
        return super.getEvents(portalControllerContext, start, end);
    }

    private Event fillEvent(Document document, NuxeoController nuxeoController) {
        String id = document.getId();
        String title = document.getTitle();
        Date startDate = document.getDate("vevent:dtstart");
        Date endDate = document.getDate("vevent:dtend");
        String bckgcolor = document.getString("vevent:color");
        String dept = document.getString("ttctik:departement");
        if (dept != null) {
            if ("aca".equals(dept)) {
                bckgcolor = InteractikCalendarColor.ACADEMIE_BRETAGNE.toString();
            } else if ("22".equals(dept)) {
                bckgcolor = InteractikCalendarColor.COTE_D_ARMOR.toString();
            } else if ("29".equals(dept)) {
                bckgcolor = InteractikCalendarColor.FINISTERE.toString();
            } else if ("35".equals(dept)) {
                bckgcolor = InteractikCalendarColor.ILE_ET_VILAINE.toString();
            } else if ("53".equals(dept)) {
                bckgcolor = InteractikCalendarColor.MORBIHAN.toString();
            }
        }
        boolean allDay = BooleanUtils.isTrue((Boolean)document.getProperties().getBoolean("vevent:allDay"));
        String viewURL = nuxeoController.getLink(document).getUrl();
        String idEventSrc = document.getString("sync:idSource");
        String idParentSrc = document.getString("sync:idParentSource");
        return new Event(id, title, startDate, endDate, allDay, bckgcolor, viewURL, idEventSrc, idParentSrc);
    }
}

