/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikEventToSync;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.calendar.view.portlet.model.events.EventKey;
import org.osivia.services.calendar.view.portlet.model.events.EventToSync;

public class InteractikSynchronizationCommand
implements INuxeoCommand {
    private NuxeoQueryFilterContext queryContext;
    private final String contextPath;
    private Map<EventKey, EventToSync> mapVevent;
    private final String parentPath;
    protected static final Log logger = LogFactory.getLog(InteractikSynchronizationCommand.class);

    public InteractikSynchronizationCommand(NuxeoQueryFilterContext queryContext, String contextPath, String parentPath, Map<EventKey, EventToSync> mapVevent) {
        this.queryContext = queryContext;
        this.contextPath = contextPath;
        this.mapVevent = mapVevent;
        this.parentPath = parentPath;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        PropertyMap map;
        Documents documents = (Documents)this.list(nuxeoSession);
        String idSource = null;
        Calendar calLastModified = Calendar.getInstance();
        ArrayList<String> documentsToDelete = new ArrayList<String>();
        ArrayList<InteractikEventToSync> documentsToUpdate = new ArrayList<InteractikEventToSync>();
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        for (Document document : documents) {
            InteractikEventToSync eventToSync;
            logger.info((Object)("Traitement de l'\u00e9v\u00e9nement : " + document.getId()));
            idSource = document.getString("sync:idSource");
            if (!StringUtils.isNotEmpty((String)idSource)) continue;
            String idParentSource = document.getString("sync:idParentSource");
            EventKey eventKey = new EventKey(idSource, idParentSource, null);
            Date lastModified = document.getDate("sync:lastModified");
            if (lastModified != null) {
                calLastModified.setTime(lastModified);
            }
            if ((eventToSync = (InteractikEventToSync)this.mapVevent.get(eventKey)) == null) {
                documentsToDelete.add(document.getId());
                continue;
            }
            if (calLastModified != null && eventToSync.getLastModifiedSource().getTime().compareTo(calLastModified.getTime()) != 0) {
                eventToSync.setId(document.getId());
                documentsToUpdate.add(eventToSync);
            }
            this.mapVevent.remove(eventKey);
        }
        for (String documentId : documentsToDelete) {
            documentService.remove(documentId);
        }
        for (InteractikEventToSync eventToUpdate : documentsToUpdate) {
            map = this.fillMap(eventToUpdate, idSource);
            documentService.update(new DocRef(eventToUpdate.getId()), map, true);
        }
        for (EventToSync eventToCreate : this.mapVevent.values()) {
            map = this.fillMap((InteractikEventToSync)eventToCreate, idSource);
            documentService.createDocument(new DocRef(this.parentPath), "VEVENT", null, map, true);
        }
        return null;
    }

    private Object list(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append(" (ecm:primaryType='VEVENT' OR ecm:primaryType='VEVENTInteractik') ");
        clause.append(" AND (sync:idParentSource is not null) ");
        clause.append(" ORDER BY vevent:dtstart");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)this.queryContext, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.Query");
        request.setHeader("X-NXDocumentProperties", "*");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        return request.execute();
    }

    private PropertyMap fillMap(InteractikEventToSync event, String idSource) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyMap map = new PropertyMap();
        if (event.isAllDay()) {
            map.set("vevent:dtend", this.formatDate(event.getEndCal()));
            map.set("vevent:dtstart", this.formatDate(event.getStartCal()));
        } else {
            map.set("vevent:dtend", this.getDateWithServerTimeZone(event.getEndCal()));
            map.set("vevent:dtstart", this.getDateWithServerTimeZone(event.getStartCal()));
        }
        map.set("dc:title", event.getTitle());
        map.set("dc:description", event.getDescription());
        map.set("sync:idParentSource", event.getIdAgendaSource());
        map.set("sync:idSource", event.getIdEventSource());
        map.set("sync:created", this.getDateWithServerTimeZone(event.getCreateCalSource()));
        map.set("sync:lastModified", this.getDateWithServerTimeZone(event.getLastModifiedSource()));
        map.set("vevent:allDay", Boolean.valueOf(event.isAllDay()));
        map.set("ttctik:departement", event.getDepartment());
        map.set("ttctik:ville", event.getVille());
        map.set("ttctik:datedebutinscription", event.getDateDebutInscription());
        map.set("ttctik:datefininscription", event.getDateFinInscription());
        map.set("ttctik:urlInscription", event.getUrlInscription());
        map.set("ttctik:imported", Boolean.valueOf(true));
        return map;
    }

    private Date getDateWithServerTimeZone(Calendar calDate) {
        if (calDate == null) {
            return null;
        }
        calDate.setTimeZone(TimeZone.getDefault());
        return calDate.getTime();
    }

    private String formatDate(Calendar calDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        calDate.setTimeZone(TimeZone.getDefault());
        return sdf.format(calDate.getTime());
    }

    public String getId() {
        return "Calendar/" + this.contextPath;
    }
}

