/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.service;

import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;
import fr.toutatice.services.calendar.view.portlet.model.calendar.InteractikCalendarData;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikDailyCalendarEventsData;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikDailyEvent;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikEventToSync;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.VEvent;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.service.CalendarViewServiceImpl;
import org.osivia.services.calendar.view.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class InteractikCalendarViewServiceImpl
extends CalendarViewServiceImpl {
    private static final String DEPARTEMENT_PROPERTY = "X-DEPARTEMENT";
    private static final String VILLE_PROPERTY = "X-VILLE";
    private static final String DATE_DEBUT_INSCRIPTION_PROPERTY = "X-DATE_DEBUT_INSCRIPTION";
    private static final String DATE_FIN_INSCRIPTION_PROPERTY = "X-DATE_FIN_INSCRIPTION";
    private static final String URLINSCRIPTION_PROPERTY = "X-URLINSCRIPTION";
    private static final String DATE_FORMAT = "yyyyMMdd";
    protected static final Log logger = LogFactory.getLog(InteractikCalendarViewServiceImpl.class);

    public JSONArray loadEventsArray(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        if (calendarData instanceof InteractikCalendarData && ((InteractikCalendarData)calendarData).isAgendaInteractik()) {
            EventsData eventsData = this.getEventsData(portalControllerContext, calendarData);
            List listEvent = ((InteractikDailyCalendarEventsData)eventsData).getEvents();
            Map mapColor = this.getSourcesColor(portalControllerContext);
            JSONArray array = new JSONArray();
            JSONObject object = null;
            Iterator iterator = listEvent.iterator();
            InteractikDailyEvent event = null;
            SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            SimpleDateFormat formaterAllDay = new SimpleDateFormat("yyyy-MM-dd");
            while (iterator.hasNext()) {
                event = (InteractikDailyEvent)iterator.next();
                object = new JSONObject();
                object.put((Object)"text", (Object)event.getTitle());
                if (event.isAllDay()) {
                    object.put((Object)"start_date", (Object)formaterAllDay.format(event.getStartDate()));
                    object.put((Object)"end_date", (Object)formaterAllDay.format(event.getEndDate()));
                } else {
                    object.put((Object)"start_date", (Object)formater.format(event.getStartDate()));
                    object.put((Object)"end_date", (Object)formater.format(event.getEndDate()));
                }
                object.put((Object)"doc_id", (Object)event.getId());
                object.put((Object)"color", (Object)event.getBckgColor());
                object.put((Object)"view_url", (Object)event.getViewURL());
                if (event.getBckgColor() == null) {
                    if (event.getIdParentSource() == null) {
                        if (mapColor.get("PRIMARY") != null) {
                            object.put((Object)"extraClass", (Object)((CalendarColor)mapColor.get("PRIMARY")).getBackgroundClass());
                        }
                    } else if (mapColor.get(event.getIdParentSource()) == null) {
                        object.put((Object)"extraClass", (Object)InteractikCalendarColor.DEFAULT);
                    } else {
                        object.put((Object)"extraClass", (Object)((CalendarColor)mapColor.get(event.getIdParentSource())).getBackgroundClass());
                    }
                } else {
                    object.put((Object)"extraClass", (Object)InteractikCalendarColor.fromId((String)event.getBckgColor()).getBackgroundClass());
                }
                object.put((Object)"ville", (Object)event.getVille());
                array.add((Object)object);
            }
            return array;
        }
        return super.loadEventsArray(portalControllerContext, calendarData);
    }

    public InteractikEventToSync buildEvent(VEvent vevent, String idAgenda, TimeZone timeZoneAllEvent) throws PortletException {
        String date;
        Calendar startReccuringStartSource;
        boolean allDay = vevent.getStartDate().getValue().length() == 8 && vevent.getEndDate().getValue().length() == 8;
        Calendar startCal = Calendar.getInstance();
        if (vevent.getStartDate().getTimeZone() != null) {
            startCal.setTimeZone((java.util.TimeZone)vevent.getStartDate().getTimeZone());
        } else {
            startCal.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
        }
        startCal.setTime((Date)vevent.getStartDate().getDate());
        Calendar endCal = Calendar.getInstance();
        if (vevent.getEndDate().getTimeZone() != null) {
            endCal.setTimeZone((java.util.TimeZone)vevent.getEndDate().getTimeZone());
        } else {
            endCal.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
        }
        endCal.setTime((Date)vevent.getEndDate().getDate());
        Calendar createdCal = Calendar.getInstance();
        if (vevent.getCreated().getTimeZone() != null) {
            createdCal.setTimeZone((java.util.TimeZone)vevent.getCreated().getTimeZone());
        } else {
            createdCal.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
        }
        createdCal.setTime((Date)vevent.getCreated().getDate());
        Calendar lastModifiedCal = Calendar.getInstance();
        if (vevent.getLastModified().getTimeZone() != null) {
            lastModifiedCal.setTimeZone((java.util.TimeZone)vevent.getLastModified().getTimeZone());
        } else {
            lastModifiedCal.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
        }
        lastModifiedCal.setTime((Date)vevent.getLastModified().getDate());
        if (vevent.getRecurrenceId() == null) {
            startReccuringStartSource = null;
        } else {
            startReccuringStartSource = Calendar.getInstance();
            if (vevent.getRecurrenceId().getTimeZone() != null) {
                startReccuringStartSource.setTimeZone((java.util.TimeZone)vevent.getRecurrenceId().getTimeZone());
            } else {
                startReccuringStartSource.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
            }
            startReccuringStartSource.setTime((Date)vevent.getRecurrenceId().getDate());
        }
        String description = vevent.getDescription() == null ? null : vevent.getDescription().getValue();
        String summary = vevent.getSummary() == null ? null : vevent.getSummary().getValue();
        String uid = vevent.getUid() == null ? null : vevent.getUid().getValue();
        String department = null;
        String urlInscription = null;
        String ville = null;
        Date dateDebutInscription = null;
        Date dateFinInscription = null;
        if (vevent.getProperty(DEPARTEMENT_PROPERTY) != null) {
            department = vevent.getProperty(DEPARTEMENT_PROPERTY).getValue();
        }
        if (vevent.getProperty(URLINSCRIPTION_PROPERTY) != null) {
            urlInscription = vevent.getProperty(URLINSCRIPTION_PROPERTY).getValue();
        }
        if (vevent.getProperty(VILLE_PROPERTY) != null) {
            ville = vevent.getProperty(VILLE_PROPERTY).getValue();
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        if (vevent.getProperty(DATE_DEBUT_INSCRIPTION_PROPERTY) != null) {
            date = vevent.getProperty(DATE_DEBUT_INSCRIPTION_PROPERTY).getValue();
            try {
                dateDebutInscription = format.parse(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (vevent.getProperty(DATE_FIN_INSCRIPTION_PROPERTY) != null) {
            date = vevent.getProperty(DATE_FIN_INSCRIPTION_PROPERTY).getValue();
            try {
                dateFinInscription = format.parse(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return new InteractikEventToSync(null, summary, allDay, startCal, endCal, description, idAgenda, uid, createdCal, lastModifiedCal, startReccuringStartSource, department, ville, dateDebutInscription, dateFinInscription, urlInscription);
    }

    private ICalendarGenerator getGenerator(PortalControllerContext portalControllerContext, PeriodTypes periodType) throws PortletException {
        ICalendarGenerator result = null;
        Map generators = this.applicationContext.getBeansOfType(ICalendarGenerator.class);
        for (ICalendarGenerator generator : generators.values()) {
            if (!generator.getPeriodType().getViewPath().equals(periodType.getViewPath())) continue;
            result = generator;
            generator.setPeriodType(periodType);
            break;
        }
        return result;
    }

    public CalendarData getCalendarData(PortalControllerContext portalControllerContext, String periodTypeName) throws PortletException {
        PeriodTypes periodType = super.getPeriodType(portalControllerContext, periodTypeName);
        ICalendarGenerator generator = this.getGenerator(portalControllerContext, periodType);
        return generator.generateCalendarData(portalControllerContext, periodType);
    }
}

