/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.service.generator;

import fr.toutatice.services.calendar.view.portlet.model.calendar.InteractikCalendarData;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikDailyCalendarEventsData;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikEvent;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikTimeSlotEvent;
import fr.toutatice.services.calendar.view.portlet.service.generator.InteractikCalendarGeneratorImpl;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletException;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.DailyCalendarEventsData;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.model.events.TimeSlotEvent;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service(value="interactikSchedulerCalendarGenerator")
@Primary
public class InteractikSchedulerCalendarGeneratorImpl
extends InteractikCalendarGeneratorImpl {
    public InteractikSchedulerCalendarGeneratorImpl() {
        this.periodType = PeriodTypes.WEEK;
    }

    protected EventsData generateSpecializedEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData, List<Event> events) throws PortletException {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Calendar startCalendar = GregorianCalendar.getInstance(locale);
        if (((InteractikCalendarData)calendarData).isAgendaInteractik()) {
            ArrayList<InteractikTimeSlotEvent> dailyEvents = new ArrayList<InteractikTimeSlotEvent>(events.size());
            for (Event event : events) {
                Date currentDate = DateUtils.truncate((Date)startCalendar.getTime(), (int)5);
                InteractikTimeSlotEvent timeSlotEvent = new InteractikTimeSlotEvent((InteractikEvent)event, currentDate);
                timeSlotEvent.setVille(((InteractikEvent)event).getVille());
                dailyEvents.add(timeSlotEvent);
            }
            InteractikDailyCalendarEventsData eventsData = new InteractikDailyCalendarEventsData();
            eventsData.setEvents(dailyEvents);
            return eventsData;
        }
        ArrayList<TimeSlotEvent> dailyEvents = new ArrayList<TimeSlotEvent>(events.size());
        for (Event event : events) {
            Date currentDate = DateUtils.truncate((Date)startCalendar.getTime(), (int)5);
            TimeSlotEvent timeSlotEvent = new TimeSlotEvent(event, currentDate);
            dailyEvents.add(timeSlotEvent);
        }
        DailyCalendarEventsData eventsData = new DailyCalendarEventsData();
        eventsData.setEvents(dailyEvents);
        return eventsData;
    }
}

