/*
 * (C) Copyright 2016 OSIVIA (http://www.osivia.com)
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
package fr.toutatice.services.calendar.batch;

import java.text.ParseException;

import javax.portlet.PortletConfig;
import javax.portlet.PortletException;

import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.batch.IBatchService;
import org.osivia.portal.api.locator.Locator;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;

/**
 * Starter class used to provide the webapp portlet context through a ldap service Spring context
 * @author Loïc Billon
 * @since 4.4
 */
public class CalendarProviderPortlet extends CMSPortlet {
	
	/** Batch evrigo */
	private SynchronizationEvrigoBatch batch = new SynchronizationEvrigoBatch();

    @Override
    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        
        IBatchService batchService = Locator.findMBean(IBatchService.class, IBatchService.MBEAN_NAME);

		try {
			batch.setPortletContext(getPortletContext());
			
			batchService.addBatch(batch);
		} catch (ParseException e) {
			throw new PortletException(e);
		} catch (PortalException e) {
			throw new PortletException(e);
		}
        
    }

    // @Override
    public void destroy() {

        super.destroy();

        IBatchService batchService = Locator.findMBean(IBatchService.class, IBatchService.MBEAN_NAME);
        batchService.removeBatch(batch);
        
    }

}
