package fr.toutatice.services.calendar.common.model;

import java.util.List;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * Interactik calendar event properties java-bean.
 * 
 * @author Cédric Krommenhoek
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class InteractikCalendarEventProperties {

    /** Organisateurs. */
    private List<String> organisateurs;
    /** Pôles disciplinaires. */
    private List<String> polesDisciplinaires;
    /** Thèmes. */
    private List<String> themes;
    /** Niveaux. */
    private List<String> niveaux;
    /** Contenus. */
    private List<String> contenus;
    /** Repères DNE. */
    private List<String> reperesDne;


    /**
     * Constructor.
     */
    public InteractikCalendarEventProperties() {
        super();
    }


    /**
     * Getter for organisateurs.
     * 
     * @return the organisateurs
     */
    public List<String> getOrganisateurs() {
        return organisateurs;
    }

    /**
     * Setter for organisateurs.
     * 
     * @param organisateurs the organisateurs to set
     */
    public void setOrganisateurs(List<String> organisateurs) {
        this.organisateurs = organisateurs;
    }

    /**
     * Getter for polesDisciplinaires.
     * 
     * @return the polesDisciplinaires
     */
    public List<String> getPolesDisciplinaires() {
        return polesDisciplinaires;
    }

    /**
     * Setter for polesDisciplinaires.
     * 
     * @param polesDisciplinaires the polesDisciplinaires to set
     */
    public void setPolesDisciplinaires(List<String> polesDisciplinaires) {
        this.polesDisciplinaires = polesDisciplinaires;
    }

    /**
     * Getter for themes.
     * 
     * @return the themes
     */
    public List<String> getThemes() {
        return themes;
    }

    /**
     * Setter for themes.
     * 
     * @param themes the themes to set
     */
    public void setThemes(List<String> themes) {
        this.themes = themes;
    }

    /**
     * Getter for niveaux.
     * 
     * @return the niveaux
     */
    public List<String> getNiveaux() {
        return niveaux;
    }

    /**
     * Setter for niveaux.
     * 
     * @param niveaux the niveaux to set
     */
    public void setNiveaux(List<String> niveaux) {
        this.niveaux = niveaux;
    }

    /**
     * Getter for contenus.
     * 
     * @return the contenus
     */
    public List<String> getContenus() {
        return contenus;
    }

    /**
     * Setter for contenus.
     * 
     * @param contenus the contenus to set
     */
    public void setContenus(List<String> contenus) {
        this.contenus = contenus;
    }

    /**
     * Getter for reperesDne.
     * @return the reperesDne
     */
    public List<String> getReperesDne() {
        return reperesDne;
    }

    /**
     * Setter for reperesDne.
     * @param reperesDne the reperesDne to set
     */
    public void setReperesDne(List<String> reperesDne) {
        this.reperesDne = reperesDne;
    }

}
