package fr.toutatice.services.calendar.common.repository;

import java.util.ArrayList;
import java.util.List;

import javax.portlet.PortletException;

import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.osivia.portal.api.context.PortalControllerContext;
import org.springframework.stereotype.Repository;

import fr.toutatice.services.calendar.common.InteractikCalendarConstant;
import fr.toutatice.services.calendar.common.model.InteractikCalendarEventProperties;

/**
 * Interactik calendar event common repository implementation.
 * 
 * @author Cédric Krommenhoek
 * @see InteractikCalendarEventRepository
 */
@Repository
public class InteractikCalendarEventRepositoryImpl implements InteractikCalendarEventRepository {

    /**
     * Constructor.
     */
    public InteractikCalendarEventRepositoryImpl() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public void fillInteractikEventProperties(PortalControllerContext portalControllerContext, Document document,
            InteractikCalendarEventProperties interactikProperties) throws PortletException {
        // Organisateurs
        List<String> organisateurs = this.getDocumentPropertyList(document, InteractikCalendarConstant.ORGANISATEURS_PROPERTY);
        interactikProperties.setOrganisateurs(organisateurs);
        // Pôles disciplinaires
        List<String> polesDisciplinaires = this.getDocumentPropertyList(document, InteractikCalendarConstant.POLES_DISCIPLINAIRES_PROPERTY);
        interactikProperties.setPolesDisciplinaires(polesDisciplinaires);
        // Thèmes
        List<String> themes = this.getDocumentPropertyList(document, InteractikCalendarConstant.THEMES_PROPERTY);
        interactikProperties.setThemes(themes);
        // Niveaux
        List<String> niveaux = this.getDocumentPropertyList(document, InteractikCalendarConstant.NIVEAUX_PROPERTY);
        interactikProperties.setNiveaux(niveaux);
        // Contenus
        List<String> contenus = this.getDocumentPropertyList(document, InteractikCalendarConstant.CONTENUS_PROPERTY);
        interactikProperties.setContenus(contenus);
        // Repères DNE
        List<String> reperesDne = this.getDocumentPropertyList(document, InteractikCalendarConstant.REPERES_DNE_PROPERTY);
        interactikProperties.setReperesDne(reperesDne);
    }


    /**
     * Get Nuxeo document property list.
     * 
     * @param document Nuxeo document
     * @param property Nuxeo document property
     * @return list
     */
    private List<String> getDocumentPropertyList(Document document, String property) {
        PropertyList propertyList;
        if (document == null) {
            propertyList = null;
        } else {
            propertyList = document.getProperties().getList(property);
        }

        List<String> list;
        if ((propertyList == null) || propertyList.isEmpty()) {
            list = null;
        } else {
            list = new ArrayList<>(propertyList.size());
            for (int i = 0; i < propertyList.size(); i++) {
                String item = propertyList.getString(i);
                list.add(item);
            }
        }

        return list;
    }

}
