package fr.toutatice.services.calendar.view.portlet.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.osivia.services.calendar.view.portlet.controller.AdminCalendarController;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

import fr.toutatice.services.calendar.view.portlet.model.Cooperative;

/**
 * Interactik calendar admin portlet controller.
 * 
 * @author Cédric Krommenhoek
 * @see AdminCalendarController
 */
@Controller
@RequestMapping("ADMIN")
@Primary
public class InteractikAdminCalendarController extends AdminCalendarController {

    /**
     * Constructor.
     */
    public InteractikAdminCalendarController() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    @RenderMapping
    public String admin(RenderRequest request, RenderResponse response) throws PortletException {
        return "admin-interactik";
    }


    /**
     * Get cooperatives model attribute.
     * 
     * @param request portlet request
     * @param response portlet response
     * @return cooperatives
     * @throws PortletException
     */
    @ModelAttribute("cooperatives")
    public List<Cooperative> getCooperatives(PortletRequest request, PortletResponse response) throws PortletException {
        return new ArrayList<>(Arrays.asList(Cooperative.values()));
    }

}
