package fr.toutatice.services.calendar.view.portlet.model.events;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.osivia.services.calendar.view.portlet.model.events.EventToSync;


public class InteractikEventToSync extends EventToSync {

	private String department;
	
	private String ville;
	
	private Date dateDebutInscription;
	
	private Date dateFinInscription;
	
	private String urlInscription;
	
    /** Organisateurs. */
    private List<String> organisateurs;
    /** Pôles disciplinaires. */
    private List<String> polesDisciplinaires;
    /** Thèmes. */
    private List<String> themes;
    /** Niveaux. */
    private List<String> niveaux;
    /** Contenus. */
    private List<String> contenus;
    /** Repères DNE. */
    private List<String> reperesDne;


	public InteractikEventToSync(String id, String title, boolean allDay, Calendar start, Calendar end, String desc,
			String idAgendaSrc, String idEventSrc, Calendar createdSrc, Calendar lastModifiedSrc,
			Calendar startReccuring, String location) {
		super(id, title, allDay, start, end, desc, idAgendaSrc, idEventSrc, createdSrc, lastModifiedSrc, startReccuring, location);
	}
	
	public InteractikEventToSync(String id, String title, boolean allDay, Calendar start, Calendar end, String desc,
			String idAgendaSrc, String idEventSrc, Calendar createdSrc, Calendar lastModifiedSrc,
			Calendar startReccuring, String location, String department, String ville, Date dateDebutInscription, Date dateFinInscription, String urlInscription) {
		super(id, title, allDay, start, end, desc, idAgendaSrc, idEventSrc, createdSrc, lastModifiedSrc, startReccuring, location);
		this.department = department;
		this.ville = ville;
		this.dateDebutInscription = dateDebutInscription;
		this.dateFinInscription = dateFinInscription;
		this.urlInscription = urlInscription;
	}

	public String getDepartment() {
		return department;
	}

	public void setDepartment(String department) {
		this.department = department;
	}

	public String getThematic() {
		return ville;
	}

	public void setThematic(String thematic) {
		this.ville = thematic;
	}

	public String getUrlInscription() {
		return urlInscription;
	}

	public void setUrlInscription(String urlInscription) {
		this.urlInscription = urlInscription;
	}

	public String getVille() {
		return ville;
	}

	public void setVille(String ville) {
		this.ville = ville;
	}

	public Date getDateDebutInscription() {
		return dateDebutInscription;
	}

	public void setDateDebutInscription(Date dateDebutInscription) {
		this.dateDebutInscription = dateDebutInscription;
	}

	public Date getDateFinInscription() {
		return dateFinInscription;
	}

	public void setDateFinInscription(Date dateFinInscription) {
		this.dateFinInscription = dateFinInscription;
	}


    /**
     * Getter for organisateurs.
     * 
     * @return the organisateurs
     */
    public List<String> getOrganisateurs() {
        return organisateurs;
    }

    /**
     * Setter for organisateurs.
     * 
     * @param organisateurs the organisateurs to set
     */
    public void setOrganisateurs(List<String> organisateurs) {
        this.organisateurs = organisateurs;
    }

    /**
     * Getter for polesDisciplinaires.
     * 
     * @return the polesDisciplinaires
     */
    public List<String> getPolesDisciplinaires() {
        return polesDisciplinaires;
    }

    /**
     * Setter for polesDisciplinaires.
     * 
     * @param polesDisciplinaires the polesDisciplinaires to set
     */
    public void setPolesDisciplinaires(List<String> polesDisciplinaires) {
        this.polesDisciplinaires = polesDisciplinaires;
    }

    /**
     * Getter for themes.
     * 
     * @return the themes
     */
    public List<String> getThemes() {
        return themes;
    }

    /**
     * Setter for themes.
     * 
     * @param themes the themes to set
     */
    public void setThemes(List<String> themes) {
        this.themes = themes;
    }


    /**
     * Getter for niveaux.
     * 
     * @return the niveaux
     */
    public List<String> getNiveaux() {
        return niveaux;
    }


    /**
     * Setter for niveaux.
     * 
     * @param niveaux the niveaux to set
     */
    public void setNiveaux(List<String> niveaux) {
        this.niveaux = niveaux;
    }


    /**
     * Getter for contenus.
     * 
     * @return the contenus
     */
    public List<String> getContenus() {
        return contenus;
    }

    /**
     * Setter for contenus.
     * 
     * @param contenus the contenus to set
     */
    public void setContenus(List<String> contenus) {
        this.contenus = contenus;
    }

    /**
     * Getter for reperesDne.
     * 
     * @return the reperesDne
     */
    public List<String> getReperesDne() {
        return reperesDne;
    }

    /**
     * Setter for reperesDne.
     * 
     * @param reperesDne the reperesDne to set
     */
    public void setReperesDne(List<String> reperesDne) {
        this.reperesDne = reperesDne;
    }

}
