package fr.toutatice.services.calendar.edition.portlet.model;

import org.osivia.services.calendar.common.model.AbstractCalendarEditionForm;
import org.osivia.services.calendar.edition.portlet.model.CalendarEditionForm;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

/**
 * Calendar edition form java-bean.
 * 
 * @author Cédric Krommenhoek
 * @see AbstractCalendarEditionForm
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class InteractikCalendarEditionForm extends CalendarEditionForm {

	private boolean agendaInteractik;
	
	/** Uploaded temporary file. */
	private MultipartFile uploadedTemporaryFile;
	
	/**
     * Constructor.
     */
    public InteractikCalendarEditionForm() {
        super();
    }

	public MultipartFile getUploadedTemporaryFile() {
		return uploadedTemporaryFile;
	}

	public void setUploadedTemporaryFile(MultipartFile uploadedTemporaryFile) {
		this.uploadedTemporaryFile = uploadedTemporaryFile;
	}

	public boolean isAgendaInteractik() {
		return agendaInteractik;
	}

	public void setAgendaInteractik(boolean agendaInteractik) {
		this.agendaInteractik = agendaInteractik;
	}

}
