package fr.toutatice.services.calendar.event.view.portlet.model;

import org.osivia.portal.api.portlet.Refreshable;
import org.osivia.services.calendar.event.view.portlet.model.CalendarEventViewForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import fr.toutatice.services.calendar.common.model.InteractikCalendarEventProperties;

/**
 * Interactik calendar event view form java-bean.
 * 
 * @author Cédric Krommenhoek
 * @see CalendarEventViewForm
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Refreshable
public class InteractikCalendarEventViewForm extends CalendarEventViewForm {

    /** Formatted date. */
    private String formattedDate;
    /** Formatted time. */
    private String formattedTime;
    /** Twitter URL. */
    private String twitterUrl;
    /** Facebook URL. */
    private String facebookUrl;


    /** Interactik properties. */
    @Autowired
    private InteractikCalendarEventProperties interactik;


    /**
     * Constructor.
     */
	public InteractikCalendarEventViewForm() {
		super();
	}


    /**
     * Getter for formattedDate.
     * 
     * @return the formattedDate
     */
    public String getFormattedDate() {
        return formattedDate;
    }

    /**
     * Setter for formattedDate.
     * 
     * @param formattedDate the formattedDate to set
     */
    public void setFormattedDate(String formattedDate) {
        this.formattedDate = formattedDate;
    }

    /**
     * Getter for formattedTime.
     * 
     * @return the formattedTime
     */
    public String getFormattedTime() {
        return formattedTime;
    }

    /**
     * Setter for formattedTime.
     * 
     * @param formattedTime the formattedTime to set
     */
    public void setFormattedTime(String formattedTime) {
        this.formattedTime = formattedTime;
    }

    /**
     * Getter for twitterUrl.
     * 
     * @return the twitterUrl
     */
    public String getTwitterUrl() {
        return twitterUrl;
    }

    /**
     * Setter for twitterUrl.
     * 
     * @param twitterUrl the twitterUrl to set
     */
    public void setTwitterUrl(String twitterUrl) {
        this.twitterUrl = twitterUrl;
    }

    /**
     * Getter for facebookUrl.
     * 
     * @return the facebookUrl
     */
    public String getFacebookUrl() {
        return facebookUrl;
    }

    /**
     * Setter for facebookUrl.
     * 
     * @param facebookUrl the facebookUrl to set
     */
    public void setFacebookUrl(String facebookUrl) {
        this.facebookUrl = facebookUrl;
    }

    /**
     * Getter for interactik.
     * 
     * @return the interactik
     */
    public InteractikCalendarEventProperties getInteractik() {
        return interactik;
    }
	
}
