/*
 * (C) Copyright 2014 Académie de Rennes (http://www.ac-rennes.fr/), OSIVIA (http://www.osivia.com) and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 *
 *
 */
package fr.toutatice.services.calendar.plugin;

import java.util.List;
import java.util.Map;

import javax.portlet.PortletContext;

import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.player.IPlayerModule;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.services.calendar.plugin.menubar.InteractikCalendarMenubarModule;

/**
 * Add integration in toutatice-cms: define Calendar and calendar events, enable calendar to be played with the specific player.
 *
 * @author Julien Barberet
 * @see AbstractPluginPortlet
 */
public class InteractikCalendarPlugin extends AbstractPluginPortlet {

    /** Plugin name. */
    private static final String PLUGIN_NAME = "interactik.calendar.plugin";


    /**
     * Constructor.
     */
    public InteractikCalendarPlugin() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    protected String getPluginName() {
        return PLUGIN_NAME;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    protected void customizeCMSProperties(CustomizationContext context) {
        // Document types
        this.customizeDocumentTypes(context);
        // Players
        this.customizePlayers(context);
        // Menubar modules
        this.customizeMenubarModules(context);
    }


    /**
     * Customize menubar modules.
     *
     * @param context customization context
     */
    protected void customizeMenubarModules(CustomizationContext context) {
        // Menubar modules
        List<MenubarModule> modules = this.getMenubarModules(context);

        // Calendar menubar module
        MenubarModule calendar = new InteractikCalendarMenubarModule();
        modules.add(calendar);
    }


    /**
     * Customize players.
     *
     * @param context customize players
     */
    protected void customizePlayers(CustomizationContext context) {
        // Portlet context
        PortletContext portletContext = this.getPortletContext();

        // Players
        @SuppressWarnings("rawtypes")
        List<IPlayerModule> players = this.getPlayers(context);

        // Calendar player
        InteractikCalendarPlayer calendar = new InteractikCalendarPlayer(portletContext);
        players.add(calendar);
    }


    /**
     * Customize document types.
     *
     * @param context customization context
     */
    protected void customizeDocumentTypes(CustomizationContext context) {
        // Document types
        Map<String, DocumentType> types = this.getDocTypes(context);

        // Calendar event interactik
        DocumentType eventInteractik = DocumentType.createNode("VEVENTInteractik");
        eventInteractik.setIcon("glyphicons glyphicons-important-day");
        eventInteractik.setForceContextualization(true);
        eventInteractik.setEditable(true);
        types.put(eventInteractik.getName(), eventInteractik);

        // Calendar interactik
        DocumentType calendarInteractik = DocumentType.createNode("AgendaInteractik");
        calendarInteractik.addSubtypes(eventInteractik.getName());
        calendarInteractik.setIcon("glyphicons glyphicons-calendar");
        calendarInteractik.setBrowsable(false);
        calendarInteractik.setForceContextualization(true);
        calendarInteractik.setEditable(true);
        types.put(calendarInteractik.getName(), calendarInteractik);
    }

}
