package fr.toutatice.services.calendar.view.portlet.model.calendar;

import java.util.List;

import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import fr.toutatice.services.calendar.view.portlet.model.Cooperative;


/**
 * Calendar data.
 * 
 * @author Julien Barberet
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Primary
public class InteractikCalendarData extends CalendarData{

	private boolean cooperative22;
	
	private boolean cooperative29;
	
	private boolean cooperative35;
	
	private boolean cooperative56;
	
	private boolean cooperativeAcademie;
	
    /** Display cooperatives indicator. */
    private boolean displayCooperatives;

    /** Coopératives. */
    private List<Cooperative> cooperatives;


    /**
     * Default constructor.
     */
    public InteractikCalendarData() {
        super();    
    }
    

	public boolean isCooperativeCA() {
		return cooperative22;
	}

	public void setCooperativeCA(boolean cooperative22) {
		this.cooperative22 = cooperative22;
	}

	public boolean isCooperativeFI() {
		return cooperative29;
	}

	public void setCooperativeFI(boolean cooperative29) {
		this.cooperative29 = cooperative29;
	}

	public boolean isCooperativeIV() {
		return cooperative35;
	}

	public void setCooperativeIV(boolean cooperative35) {
		this.cooperative35 = cooperative35;
	}

	public boolean isCooperativeMO() {
		return cooperative56;
	}

	public void setCooperativeMO(boolean cooperative56) {
		this.cooperative56 = cooperative56;
	}

	public boolean isCooperativeAcademie() {
		return cooperativeAcademie;
	}

	public void setCooperativeAcademie(boolean cooperativeAcademie) {
		this.cooperativeAcademie = cooperativeAcademie;
	}

    /**
     * Getter for displayCooperatives.
     * 
     * @return the displayCooperatives
     */
    public boolean isDisplayCooperatives() {
        return displayCooperatives;
    }

    /**
     * Setter for displayCooperatives.
     * 
     * @param displayCooperatives the displayCooperatives to set
     */
    public void setDisplayCooperatives(boolean displayCooperatives) {
        this.displayCooperatives = displayCooperatives;
    }

    /**
     * Getter for cooperatives.
     * 
     * @return the cooperatives
     */
    public List<Cooperative> getCooperatives() {
        return cooperatives;
    }

    /**
     * Setter for cooperatives.
     * 
     * @param cooperatives the cooperatives to set
     */
    public void setCooperatives(List<Cooperative> cooperatives) {
        this.cooperatives = cooperatives;
    }
}
