package fr.toutatice.services.calendar.view.portlet.model.events;

import java.util.Date;

import org.osivia.services.calendar.view.portlet.model.events.Event;

/**
 * Event.
 *
 * @author Julien Barberet
 */
public class InteractikEvent extends Event{

    /** ville */
    private String ville;

    /**
     * Constructor.
     *
     * @param id event identifier
     * @param title event title
     * @param startDate event start date
     * @param endDate event end date
     * @param viewURL event view document URL
     */
    public InteractikEvent(String id, String title, Date startDate, Date endDate, boolean allDay, String bckgcolor, String viewURL, String idEventSrc, String idParentSrc) {
        super(id, title, startDate, endDate, allDay, bckgcolor, viewURL, idEventSrc, idParentSrc);
    }

    /**
     * Constructor.
     *
     * @param event event
     */
    public InteractikEvent(Event event) {
        this(event.getId(), event.getTitle(), event.getStartDate(), event.getEndDate(), event.isAllDay(), event.getBckgColor(),
        		event.getViewURL(), event.getIdEventSource(), event.getIdParentSource());
    }

	public String getVille() {
		return ville;
	}

	public void setVille(String ville) {
		this.ville = ville;
	}

}
