/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.osivia.services.calendar.edition.portlet.model.CalendarSynchronizationSource;

public class EventListCommand
implements INuxeoCommand {
    private NuxeoQueryFilterContext queryContext;
    private final String contextPath;
    private final Date startDate;
    private final Date endDate;
    private final String sourcesId;

    public EventListCommand(NuxeoQueryFilterContext queryContext, String contextPath, Date startDate, Date endDate, List<CalendarSynchronizationSource> listSource) {
        this.queryContext = queryContext;
        this.contextPath = contextPath;
        this.startDate = startDate;
        this.endDate = endDate;
        this.sourcesId = this.getStringValues(listSource);
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request;
        String start = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(this.startDate);
        String end = this.endDate == null ? null : DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(this.endDate);
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:mixinType = 'Schedulable' ");
        clause.append("AND ecm:path STARTSWITH '").append(this.contextPath).append("' ");
        if (StringUtils.isNotEmpty((String)end)) {
            clause.append("AND (vevent:dtstart < TIMESTAMP '").append(end).append("') ");
        }
        clause.append("AND (vevent:dtend > TIMESTAMP '").append(start).append("') ");
        clause.append("AND (sync:idParentSource is null or sync:idParentSource = '' ");
        if (this.sourcesId != null && !this.sourcesId.isEmpty()) {
            clause.append(" OR sync:idParentSource IN (").append(this.sourcesId).append(")");
        }
        clause.append(") ");
        clause.append("ORDER BY vevent:dtstart");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)this.queryContext, (String)clause.toString());
        if (NuxeoCompatibility.canUseES()) {
            request = nuxeoSession.newRequest("Document.QueryES");
            request.set("X-NXDocumentProperties", (Object)"*");
        } else {
            request = nuxeoSession.newRequest("Document.Query");
            request.setHeader("X-NXDocumentProperties", "*");
        }
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        return request.execute();
    }

    private String getStringValues(List<CalendarSynchronizationSource> values) {
        String result;
        if (values == null) {
            result = null;
        } else {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (CalendarSynchronizationSource value : values) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("'");
                builder.append(value.getId());
                builder.append("'");
            }
            result = builder.toString();
        }
        return result;
    }

    public String getId() {
        return "Calendar/" + this.contextPath;
    }
}

