/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.ConcurrentUpdateStorageException;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.lock.AbstractLockManager;
import org.nuxeo.ecm.core.storage.lock.LockException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.runtime.api.Framework;

public class VCSLockManager
extends AbstractLockManager {
    private static final Log log = LogFactory.getLog(VCSLockManager.class);
    public static final int LOCK_RETRIES = 10;
    public static final long LOCK_SLEEP_DELAY = 1L;
    public static final long LOCK_SLEEP_INCREMENT = 50L;
    protected final RepositoryImpl repository;
    protected Mapper mapper;
    protected final boolean clusteringEnabled;
    protected final ReentrantLock serializationLock;
    protected static final Lock NULL_LOCK = new Lock(null, null);
    protected final boolean caching;
    protected final LRUCache<Serializable, Lock> lockCache;
    protected static final int CACHE_SIZE = 100;

    public VCSLockManager(String repositoryName) throws StorageException {
        SQLRepositoryService repositoryService = (SQLRepositoryService)((Object)Framework.getService(SQLRepositoryService.class));
        this.repository = repositoryService.getRepositoryImpl(repositoryName);
        this.clusteringEnabled = this.repository.getRepositoryDescriptor().getClusteringEnabled();
        this.serializationLock = new ReentrantLock();
        this.caching = !this.clusteringEnabled;
        this.lockCache = this.caching ? new LRUCache(100) : null;
    }

    protected Mapper getMapper() throws StorageException {
        if (this.mapper == null) {
            this.mapper = this.repository.getBackend().newMapper(this.repository.getModel(), null, RepositoryBackend.MapperKind.LOCK_MANAGER);
        }
        return this.mapper;
    }

    protected Serializable idFromString(String id) {
        return this.repository.getModel().idFromString(id);
    }

    public void close() {
        this.serializationLock.lock();
        try {
            try {
                this.getMapper().close();
            }
            catch (StorageException e) {
                throw new NuxeoException((Throwable)((Object)e));
            }
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock getLock(String id) {
        this.serializationLock.lock();
        try {
            Lock lock;
            if (this.caching && (lock = (Lock)this.lockCache.get(id)) != null) {
                Lock lock2 = lock == NULL_LOCK ? null : lock;
                return lock2;
            }
            try {
                lock = this.getMapper().getLock(this.idFromString(id));
            }
            catch (StorageException e) {
                throw new LockException((Throwable)((Object)e));
            }
            if (this.caching) {
                this.lockCache.put((Serializable)((Object)id), lock == null ? NULL_LOCK : lock);
            }
            Lock lock3 = lock;
            return lock3;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public Lock setLock(String id, Lock lock) {
        ArrayList<StorageException> suppressed = new ArrayList<StorageException>(0);
        long sleepDelay = 1L;
        for (int i = 0; i < 10; ++i) {
            if (i > 0) {
                log.debug((Object)("Retrying lock on " + id + ": try " + (i + 1)));
            }
            try {
                return this.setLockInternal(id, lock);
            }
            catch (StorageException e) {
                suppressed.add(e);
                if (this.shouldRetry(e)) {
                    try {
                        Thread.sleep(sleepDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(interruptedException);
                    }
                    sleepDelay += 50L;
                    continue;
                }
                LockException lockException = new LockException((Throwable)((Object)e));
                for (Throwable throwable : suppressed) {
                    lockException.addSuppressed(throwable);
                }
                throw lockException;
            }
        }
        LockException exception = new LockException("Failed to lock " + id + ", too much concurrency (tried " + 10 + " times)");
        for (Throwable throwable : suppressed) {
            exception.addSuppressed(throwable);
        }
        throw exception;
    }

    protected boolean shouldRetry(StorageException e) {
        if (e instanceof ConcurrentUpdateStorageException) {
            return true;
        }
        Throwable t = e.getCause();
        if (t instanceof BatchUpdateException && t.getCause() != null) {
            t = t.getCause();
        }
        return t instanceof SQLException && this.shouldRetry((SQLException)t);
    }

    protected boolean shouldRetry(SQLException e) {
        String sqlState = e.getSQLState();
        if ("23000".equals(sqlState)) {
            return true;
        }
        if ("23001".equals(sqlState)) {
            return true;
        }
        if ("23505".equals(sqlState)) {
            return true;
        }
        return "S0003".equals(sqlState) || "S0005".equals(sqlState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock setLockInternal(String id, Lock lock) throws StorageException {
        this.serializationLock.lock();
        try {
            Lock oldLock;
            if (this.caching && (oldLock = (Lock)this.lockCache.get(id)) != null && oldLock != NULL_LOCK) {
                Lock lock2 = oldLock;
                return lock2;
            }
            oldLock = this.getMapper().setLock(this.idFromString(id), lock);
            if (this.caching && oldLock == null) {
                this.lockCache.put((Serializable)((Object)id), lock == null ? NULL_LOCK : lock);
            }
            Lock lock3 = oldLock;
            return lock3;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock removeLock(String id, String owner) {
        this.serializationLock.lock();
        try {
            Lock oldLock = null;
            if (this.caching && (oldLock = (Lock)this.lockCache.get(id)) == NULL_LOCK) {
                Lock lock = null;
                return lock;
            }
            if (oldLock != null && !this.canLockBeRemoved(oldLock, owner)) {
                oldLock = new Lock(oldLock, true);
            } else {
                try {
                    if (oldLock == null) {
                        oldLock = this.getMapper().removeLock(this.idFromString(id), owner, false);
                    } else {
                        this.getMapper().removeLock(this.idFromString(id), owner, true);
                    }
                }
                catch (StorageException e) {
                    throw new LockException((Throwable)((Object)e));
                }
            }
            if (this.caching) {
                if (oldLock != null && oldLock.getFailed()) {
                    this.lockCache.put((Serializable)((Object)id), new Lock(oldLock, false));
                } else {
                    this.lockCache.put((Serializable)((Object)id), NULL_LOCK);
                }
            }
            Lock lock = oldLock;
            return lock;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public void clearCaches() {
        this.serializationLock.lock();
        try {
            if (this.caching) {
                this.lockCache.clear();
            }
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '(' + this.repository.getName() + ')';
    }

    protected static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int max;

        public LRUCache(int max) {
            super(max, 1.0f, true);
            this.max = max;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.max;
        }
    }
}

