/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.name.RdnParser;
import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDnParser
implements NameParser {
    private static LdapDnParser instance = new LdapDnParser();

    private LdapDnParser() {
    }

    public static NameParser getNameParser() {
        return instance;
    }

    public static void parseInternal(String dn, List<Rdn> rdns) throws InvalidNameException {
        if (dn.length() == 0) {
            return;
        }
        Position pos = new Position();
        pos.start = 0;
        Rdn rdn = new Rdn();
        if (RdnParser.parse(dn, pos, rdn) != -1) {
            do {
                rdns.add(rdn);
                rdn = new Rdn();
                if (!StringTools.isCharASCII(dn, pos.start, ',') && !StringTools.isCharASCII(dn, pos.start, ';')) {
                    if (pos.start != dn.length()) {
                        throw new InvalidNameException("Bad DN : " + dn);
                    }
                    return;
                }
                ++pos.start;
            } while (RdnParser.parse(dn, pos, rdn) != -1);
            throw new InvalidNameException("Bad DN : " + dn);
        }
        throw new InvalidNameException("Bad DN : " + dn);
    }

    public static boolean validateInternal(String dn) {
        if (dn.length() == 0) {
            return true;
        }
        Position pos = new Position();
        pos.start = 0;
        if (RdnParser.isValid(dn, pos, true)) {
            do {
                if (!StringTools.isCharASCII(dn, pos.start, ',') && !StringTools.isCharASCII(dn, pos.start, ';')) {
                    return pos.start == dn.length();
                }
                ++pos.start;
            } while (RdnParser.isValid(dn, pos, false));
        }
        return false;
    }

    @Override
    public Name parse(String dn) throws InvalidNameException {
        return new LdapDN(dn);
    }
}

