/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.resource.Variant;
import org.restlet.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Conditions {
    private Date modifiedSince;
    private Date unmodifiedSince;
    private List<Tag> match;
    private List<Tag> noneMatch;

    public List<Tag> getMatch() {
        return this.match;
    }

    public Date getModifiedSince() {
        return this.modifiedSince;
    }

    public List<Tag> getNoneMatch() {
        return this.noneMatch;
    }

    public Status getStatus(Method method, Variant variant) {
        boolean matched;
        Status result = null;
        if (this.getMatch() != null && this.getMatch().size() != 0) {
            matched = false;
            boolean failed = false;
            boolean all = this.getMatch().get(0).equals(Tag.ALL);
            if (variant != null) {
                if (!all && variant.getTag() != null) {
                    Iterator<Tag> iter = this.getMatch().iterator();
                    while (!matched && iter.hasNext()) {
                        Tag tag = iter.next();
                        matched = tag.equals(variant.getTag(), false);
                    }
                } else {
                    matched = all;
                }
            } else {
                failed = all;
            }
            boolean bl = failed = failed || !matched;
            if (failed) {
                result = Status.CLIENT_ERROR_PRECONDITION_FAILED;
            }
        }
        if (result == null && this.getNoneMatch() != null && this.getNoneMatch().size() != 0) {
            matched = false;
            if (variant != null) {
                if (variant.getTag() != null) {
                    Iterator<Tag> iter = this.getNoneMatch().iterator();
                    while (!matched && iter.hasNext()) {
                        Tag tag = iter.next();
                        matched = tag.equals(variant.getTag(), Method.GET.equals(method) || Method.HEAD.equals(method));
                    }
                    if (matched) {
                        Date modifiedSince = this.getModifiedSince();
                        boolean isModifiedSince = modifiedSince != null && (DateUtils.after(new Date(), modifiedSince) || variant.getModificationDate() == null || DateUtils.after(modifiedSince, variant.getModificationDate()));
                        matched = !isModifiedSince;
                    }
                }
            } else {
                matched = this.getNoneMatch().get(0).equals(Tag.ALL);
            }
            if (matched) {
                result = Method.GET.equals(method) || Method.HEAD.equals(method) ? Status.REDIRECTION_NOT_MODIFIED : Status.CLIENT_ERROR_PRECONDITION_FAILED;
            }
        }
        if (result == null && this.getModifiedSince() != null && variant != null) {
            boolean isModifiedSince;
            Date modifiedSince = this.getModifiedSince();
            boolean bl = isModifiedSince = DateUtils.after(new Date(), modifiedSince) || variant.getModificationDate() == null || DateUtils.after(modifiedSince, variant.getModificationDate());
            if (!isModifiedSince) {
                result = Status.REDIRECTION_NOT_MODIFIED;
            }
        }
        if (result == null && this.getUnmodifiedSince() != null && variant != null) {
            boolean isUnModifiedSince;
            Date unModifiedSince = this.getUnmodifiedSince();
            boolean bl = isUnModifiedSince = unModifiedSince == null || variant.getModificationDate() == null || DateUtils.after(variant.getModificationDate(), unModifiedSince);
            if (!isUnModifiedSince) {
                result = Status.CLIENT_ERROR_PRECONDITION_FAILED;
            }
        }
        return result;
    }

    public Date getUnmodifiedSince() {
        return this.unmodifiedSince;
    }

    public boolean hasSome() {
        return this.getMatch() != null && !this.getMatch().isEmpty() || this.getNoneMatch() != null && !this.getNoneMatch().isEmpty() || this.getModifiedSince() != null || this.getUnmodifiedSince() != null;
    }

    public void setMatch(List<Tag> tags) {
        this.match = tags;
    }

    public void setModifiedSince(Date date) {
        this.modifiedSince = DateUtils.unmodifiable(date);
    }

    public void setNoneMatch(List<Tag> tags) {
        this.noneMatch = tags;
    }

    public void setUnmodifiedSince(Date date) {
        this.unmodifiedSince = DateUtils.unmodifiable(date);
    }
}

