/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.search.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewState;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewStateImpl;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.search.ui.SearchUIService;
import org.nuxeo.search.ui.localconfiguration.SearchConfiguration;

public class SearchUIServiceImpl
implements SearchUIService {
    private static Log log = LogFactory.getLog(SearchUIServiceImpl.class);
    public static final String SEARCH_CONTENT_VIEWS_CATEGORY = "SEARCH_CONTENT_VIEWS";
    public static final String CONTENT_VIEW_NAME_PROPERTY = "contentViewName";
    public static final String SAVED_SEARCHES_PROVIDER_NAME = "SAVED_SEARCHES";
    public static final String SHARED_SEARCHES_PROVIDER_NAME = "SHARED_SAVED_SEARCHES";
    public static final String CONTENT_VIEW_DISPLAY_FACET = "ContentViewDisplay";

    @Override
    public List<ContentViewHeader> getContentViewHeaders(ActionContext actionContext) {
        return this.getContentViewHeaders(actionContext, null);
    }

    @Override
    public List<ContentViewHeader> getContentViewHeaders(ActionContext actionContext, DocumentModel doc) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        List actions = actionService.getActions(SEARCH_CONTENT_VIEWS_CATEGORY, actionContext);
        List<String> contentViewNames = new ArrayList<String>();
        for (Action action : actions) {
            String contentViewName = (String)action.getProperties().get(CONTENT_VIEW_NAME_PROPERTY);
            if (contentViewName == null) continue;
            contentViewNames.add(contentViewName);
        }
        contentViewNames = this.filterContentViewNames(contentViewNames, doc);
        ContentViewService contentViewService = (ContentViewService)Framework.getLocalService(ContentViewService.class);
        ArrayList<ContentViewHeader> contentViewHeaders = new ArrayList<ContentViewHeader>();
        for (String contentViewName : contentViewNames) {
            ContentViewHeader contentViewHeader = contentViewService.getContentViewHeader(contentViewName);
            if (contentViewHeader == null) continue;
            contentViewHeaders.add(contentViewHeader);
        }
        return contentViewHeaders;
    }

    protected List<String> filterContentViewNames(List<String> contentViewNames, DocumentModel currentDoc) {
        SearchConfiguration searchConfiguration = this.getSearchConfiguration(currentDoc);
        return searchConfiguration == null ? contentViewNames : searchConfiguration.filterAllowedContentViewNames(contentViewNames);
    }

    protected SearchConfiguration getSearchConfiguration(DocumentModel currentDoc) {
        LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
        return (SearchConfiguration)localConfigurationService.getConfiguration(SearchConfiguration.class, "SearchConfiguration", currentDoc);
    }

    @Override
    public DocumentModel saveSearch(CoreSession session, ContentViewState searchContentViewState, String title) {
        UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        DocumentModel uws = userWorkspaceService.getCurrentUserPersonalWorkspace(session, null);
        DocumentModel searchDoc = searchContentViewState.getSearchDocumentModel();
        searchDoc.setPropertyValue("dc:title", (Serializable)((Object)title));
        if (searchDoc.hasFacet(CONTENT_VIEW_DISPLAY_FACET)) {
            searchDoc.setPropertyValue("cvd:contentViewName", (Serializable)((Object)searchContentViewState.getContentViewName()));
            List sortInfos = searchContentViewState.getSortInfos();
            if (sortInfos != null) {
                ArrayList<Map> list = new ArrayList<Map>();
                for (SortInfo sortInfo : sortInfos) {
                    list.add(SortInfo.asMap((SortInfo)sortInfo));
                }
                searchDoc.setPropertyValue("cvd:sortInfos", list);
            }
            searchDoc.setPropertyValue("cvd:selectedLayoutColumns", (Serializable)((Object)searchContentViewState.getResultColumns()));
        } else {
            log.warn((Object)String.format("Search document type %s is missing %s facet", searchDoc.getType(), CONTENT_VIEW_DISPLAY_FACET));
        }
        PathSegmentService pathService = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
        searchDoc.setPathInfo(uws.getPathAsString(), pathService.generatePathSegment(searchDoc));
        searchDoc = session.createDocument(searchDoc);
        session.save();
        return searchDoc;
    }

    @Override
    public List<DocumentModel> getCurrentUserSavedSearches(CoreSession session) throws ClientException {
        return this.getDocuments(SAVED_SEARCHES_PROVIDER_NAME, session, session.getPrincipal().getName());
    }

    protected List<DocumentModel> getDocuments(String pageProviderName, CoreSession session, Object ... parameters) throws ClientException {
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("coreSession", (Serializable)session);
        return pageProviderService.getPageProvider(pageProviderName, null, null, null, properties, parameters).getCurrentPage();
    }

    @Override
    public List<DocumentModel> getSharedSavedSearches(CoreSession session) throws ClientException {
        return this.getDocuments(SHARED_SEARCHES_PROVIDER_NAME, session, session.getPrincipal().getName());
    }

    @Override
    public ContentViewState loadSearch(DocumentModel savedSearch) {
        if (!savedSearch.hasFacet(CONTENT_VIEW_DISPLAY_FACET)) {
            log.warn((Object)String.format("Search document type %s is missing %s facet", savedSearch.getType(), CONTENT_VIEW_DISPLAY_FACET));
            return null;
        }
        ContentViewStateImpl state = new ContentViewStateImpl();
        state.setContentViewName((String)((Object)savedSearch.getPropertyValue("cvd:contentViewName")));
        state.setSearchDocumentModel(savedSearch);
        state.setSortInfos(this.getSortInfos(savedSearch));
        state.setResultColumns((List)((Object)savedSearch.getPropertyValue("cvd:selectedLayoutColumns")));
        return state;
    }

    List<SortInfo> getSortInfos(DocumentModel savedSearch) {
        List list = (List)((Object)savedSearch.getPropertyValue("cvd:sortInfos"));
        ArrayList<SortInfo> sortInfos = new ArrayList<SortInfo>();
        for (Map info : list) {
            sortInfos.add(SortInfo.asSortInfo((Map)info));
        }
        return sortInfos;
    }
}

