/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.AbstractPackageSource;
import org.nuxeo.connect.packages.LocalPackageAsDownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;

public class LocalPackageSource
extends AbstractPackageSource
implements PackageSource {
    protected static final Log log = LogFactory.getLog(LocalPackageSource.class);

    public LocalPackageSource() {
        this.id = "local";
        this.name = "Local";
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        PackageUpdateService pus = NuxeoConnectClient.getPackageUpdateService();
        try {
            List<LocalPackage> pkgs = pus.getPackages();
            for (LocalPackage pkg : pkgs) {
                result.add(new LocalPackageAsDownloadablePackage(pkg));
            }
        }
        catch (PackageException e) {
            log.error((Object)"Error when getting local packages", (Throwable)e);
        }
        return result;
    }

    @Override
    public LocalPackageAsDownloadablePackage getPackageById(String packageId) {
        PackageUpdateService pus = NuxeoConnectClient.getPackageUpdateService();
        LocalPackageAsDownloadablePackage pkg = null;
        try {
            LocalPackage localPackage = pus.getPackage(packageId);
            if (localPackage != null) {
                pkg = new LocalPackageAsDownloadablePackage(localPackage);
            }
        }
        catch (PackageException e) {
            log.error((Object)("Error when getting local package " + packageId), (Throwable)e);
        }
        return pkg;
    }
}

