/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.file.filter.AbstractFileFilter;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FileFilterDirectoryFromFilenameFilter
extends AbstractFileFilter {
    private final FilenameFilter m_aFilenameFilter;

    public FileFilterDirectoryFromFilenameFilter(@Nonnull FilenameFilter filenameFilter) {
        this.m_aFilenameFilter = ValueEnforcer.notNull(filenameFilter, "FilenameFilter");
    }

    @Nonnull
    public final FilenameFilter getFilenameFilter() {
        return this.m_aFilenameFilter;
    }

    @Override
    public boolean accept(@Nullable File file) {
        return file != null && file.isDirectory() && this.m_aFilenameFilter.accept(file.getParentFile(), file.getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof FileFilterDirectoryFromFilenameFilter;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("filenameFilter", this.m_aFilenameFilter).toString();
    }
}

